/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import sun.dc.pr.PRException;
import sun.dc.pr.Rasterizer;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.DuctusRenderer;
import sun.java2d.pipe.ShapeDrawPipe;

public class DuctusShapeRenderer
extends DuctusRenderer
implements ShapeDrawPipe {
    CompositePipe outpipe;

    public DuctusShapeRenderer(CompositePipe compositePipe) {
        this.outpipe = compositePipe;
    }

    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        BasicStroke basicStroke;
        if (sunGraphics2D.stroke instanceof BasicStroke) {
            basicStroke = (BasicStroke)sunGraphics2D.stroke;
        } else {
            shape = sunGraphics2D.stroke.createStrokedShape(shape);
            basicStroke = null;
        }
        this.renderPath(sunGraphics2D, shape, basicStroke);
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.renderPath(sunGraphics2D, shape, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renderPath(SunGraphics2D sunGraphics2D, Shape shape, BasicStroke basicStroke) {
        Object object;
        Rasterizer rasterizer;
        block14: {
            block13: {
                PathIterator pathIterator = shape.getPathIterator(sunGraphics2D.transform);
                boolean bl = basicStroke != null && sunGraphics2D.strokeHint != 2;
                rasterizer = DuctusRenderer.createShapeRasterizer(pathIterator, sunGraphics2D.transform, basicStroke, bl, 0.5f);
                object = null;
                try {
                    try {
                        Rectangle rectangle;
                        int[] nArray;
                        block16: {
                            block15: {
                                nArray = new int[4];
                                rasterizer.getAlphaBox(nArray);
                                rectangle = new Rectangle(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
                                Rectangle rectangle2 = sunGraphics2D.getCompBounds();
                                nArray[0] = Math.max(nArray[0], rectangle2.x);
                                nArray[1] = Math.max(nArray[1], rectangle2.y);
                                nArray[2] = Math.min(nArray[2], rectangle2.x + rectangle2.width);
                                nArray[3] = Math.min(nArray[3], rectangle2.y + rectangle2.height);
                                if (nArray[0] >= nArray[2]) break block15;
                                if (nArray[1] < nArray[3]) break block16;
                            }
                            Object var20_12 = null;
                            break block13;
                        }
                        rasterizer.setOutputArea(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
                        object = this.outpipe.startSequence(sunGraphics2D, shape, rectangle, nArray);
                        int n = Rasterizer.TILE_SIZE;
                        byte[] byArray = new byte[n * n];
                        int n2 = nArray[1];
                        block4: while (n2 < nArray[3]) {
                            int n3 = nArray[0];
                            while (true) {
                                if (n3 >= nArray[2]) {
                                    n2 += n;
                                    continue block4;
                                }
                                int n4 = Math.min(n, nArray[2] - n3);
                                int n5 = Math.min(n, nArray[3] - n2);
                                int n6 = rasterizer.getTileState();
                                if (n6 == 0 || !this.outpipe.needTile(object, n3, n2, n4, n5)) {
                                    rasterizer.nextTile();
                                    this.outpipe.skipTile(object, n3, n2);
                                } else {
                                    byte[] byArray2;
                                    if (n6 == 2) {
                                        byArray2 = byArray;
                                        DuctusRenderer.getAlpha(rasterizer, byArray, 1, n, 0);
                                    } else {
                                        byArray2 = null;
                                        rasterizer.nextTile();
                                    }
                                    this.outpipe.renderPathTile(object, byArray2, 0, n, n3, n2, n4, n5);
                                }
                                n3 += n;
                            }
                        }
                        break block14;
                    }
                    catch (PRException pRException) {
                        pRException.printStackTrace();
                        Object var20_14 = null;
                        DuctusRenderer.dropRasterizer(rasterizer);
                        if (object == null) return;
                        this.outpipe.endSequence(object);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var20_15 = null;
                    DuctusRenderer.dropRasterizer(rasterizer);
                    if (object == null) throw throwable;
                    this.outpipe.endSequence(object);
                    throw throwable;
                }
            }
            DuctusRenderer.dropRasterizer(rasterizer);
            if (object == null) return;
            this.outpipe.endSequence(object);
            return;
        }
        Object var20_13 = null;
        DuctusRenderer.dropRasterizer(rasterizer);
        if (object == null) return;
        this.outpipe.endSequence(object);
    }
}

