/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;

class FocusManager
implements Serializable {
    Container focusRoot;
    Component focusOwner;
    static final long serialVersionUID = 2491878825643557906L;

    FocusManager(Container container) {
        this.focusRoot = container;
    }

    void activateFocus() {
        boolean bl = false;
        if (this.focusOwner != null) {
            bl = this.assignFocus(this.focusOwner, false);
            if (!bl) {
                bl = this.focusNext(this.focusOwner);
            }
        } else {
            bl = this.focusForward(this.focusRoot);
        }
        if (!bl) {
            this.focusRoot.requestFocus();
        }
    }

    synchronized void setFocusOwner(Component component) {
        this.focusOwner = component;
    }

    Component getFocusOwner() {
        return this.focusOwner;
    }

    boolean focusNext() {
        return this.focusNext(this.focusOwner);
    }

    boolean focusNext(Component component) {
        Object object = this.focusRoot.getTreeLock();
        synchronized (object) {
            boolean bl;
            Component component2 = component;
            if (component2 != null && component2.parent != null) {
                Container container;
                do {
                    bl = false;
                    container = component2.parent;
                    int n = 0;
                    while (n < container.ncomponents) {
                        Component component3 = container.component[n];
                        if (bl) {
                            if (this.assignFocus(component3)) {
                                boolean bl2 = true;
                                return bl2;
                            }
                            if (component3 instanceof Container && component3.isVisible() && component3.isEnabled() && this.focusForward((Container)component3)) {
                                boolean bl3 = true;
                                return bl3;
                            }
                        } else if (component3 == component2) {
                            bl = true;
                        }
                        ++n;
                    }
                } while ((component2 = container) != this.focusRoot && component2.parent != null);
            }
            if (this.focusForward(this.focusRoot)) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
    }

    boolean focusPrevious() {
        return this.focusPrevious(this.focusOwner);
    }

    boolean focusPrevious(Component component) {
        Object object = this.focusRoot.getTreeLock();
        synchronized (object) {
            boolean bl;
            Component component2 = component;
            if (component2 != null && component2.parent != null) {
                Container container;
                do {
                    bl = false;
                    container = component2.parent;
                    if (container == null) continue;
                    int n = container.ncomponents - 1;
                    while (n >= 0) {
                        Component component3 = container.component[n];
                        if (bl) {
                            if (this.assignFocus(component3)) {
                                boolean bl2 = true;
                                return bl2;
                            }
                            if (component3 instanceof Container && component3.isVisible() && component3.isEnabled() && this.focusBackward((Container)component3)) {
                                boolean bl3 = true;
                                return bl3;
                            }
                        } else if (component3 == component2) {
                            bl = true;
                        }
                        --n;
                    }
                } while ((component2 = container) != null && component2 != this.focusRoot);
            }
            if (this.focusBackward(this.focusRoot)) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
    }

    boolean assignFocus(Component component) {
        return this.assignFocus(component, true);
    }

    synchronized boolean assignFocus(Component component, boolean bl) {
        if (component.isVisible() && component.isEnabled() && (!bl || component.isFocusTraversable())) {
            component.requestFocus();
            return true;
        }
        return false;
    }

    synchronized boolean focusForward(Container container) {
        int n = 0;
        while (n < container.ncomponents) {
            Component component = container.component[n];
            if (this.assignFocus(component)) {
                return true;
            }
            if (component instanceof Container && component.isVisible() && component.isEnabled() && this.focusForward((Container)component)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    synchronized boolean focusBackward(Container container) {
        int n = container.ncomponents - 1;
        while (n >= 0) {
            Component component = container.component[n];
            if (this.assignFocus(component)) {
                return true;
            }
            if (component instanceof Container && component.isVisible() && component.isEnabled() && this.focusBackward((Container)component)) {
                return true;
            }
            --n;
        }
        return false;
    }
}

