/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.Action;
import javax.swing.DefaultPopupFactory;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;

public class JPopupMenu
extends JComponent
implements Accessible,
MenuElement {
    private static final String uiClassID = "PopupMenuUI";
    private static final Object defaultLWPopupEnabledKey = new StringBuffer("JPopupMenu.defaultLWPopupEnabledKey");
    transient Component invoker;
    transient Popup popup;
    transient Frame frame;
    private int desiredLocationX;
    private int desiredLocationY;
    private static PopupFactory popupFactory = new DefaultPopupFactory();
    private String label = null;
    private boolean paintBorder = true;
    private Insets margin = null;
    private boolean lightWeightPopupEnabled = true;
    private SingleSelectionModel selectionModel;
    private static final Object classLock = new Object();
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private boolean receivedKeyPressed;
    static /* synthetic */ Class class$javax$swing$event$PopupMenuListener;

    public static void setDefaultLightWeightPopupEnabled(boolean bl) {
        SwingUtilities.appContextPut(defaultLWPopupEnabledKey, new Boolean(bl));
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        Boolean bl = (Boolean)SwingUtilities.appContextGet(defaultLWPopupEnabledKey);
        if (bl == null) {
            SwingUtilities.appContextPut(defaultLWPopupEnabledKey, Boolean.TRUE);
            return true;
        }
        return bl;
    }

    public JPopupMenu() {
        this(null);
    }

    public JPopupMenu(String string) {
        this.label = string;
        this.lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.addMouseListener(new MouseAdapter(){});
        this.updateUI();
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.ui;
    }

    public void setUI(PopupMenuUI popupMenuUI) {
        super.setUI(popupMenuUI);
    }

    public void updateUI() {
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        switch (keyEvent.getID()) {
            case 401: {
                this.receivedKeyPressed = true;
                bl = true;
                break;
            }
            case 402: {
                if (!this.receivedKeyPressed) break;
                this.receivedKeyPressed = false;
                bl = true;
                break;
            }
            default: {
                bl = this.receivedKeyPressed;
            }
        }
        if (bl) {
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t') {
            keyEvent.consume();
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        this.selectionModel = singleSelectionModel;
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        super.add(jMenuItem);
        return jMenuItem;
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add(jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem createActionComponent(Action action) {
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon")){

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = JPopupMenu.this.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        return jMenuItem;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    public void remove(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n > this.getComponentCount() - 1) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        super.remove(n);
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.firePropertyChange("label", string2, string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        this.invalidate();
        this.repaint();
    }

    public void addSeparator() {
        this.add(new Separator());
    }

    public void insert(Action action, int n) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add((Component)jMenuItem, n);
    }

    public void insert(Component component, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        int n2 = this.getComponentCount();
        Vector vector = new Vector();
        int n3 = n;
        while (n3 < n2) {
            vector.addElement(this.getComponent(n));
            this.remove(n);
            ++n3;
        }
        this.add(component);
        int n4 = 0;
        while (n4 < vector.size()) {
            this.add((Component)vector.elementAt(n4));
            ++n4;
        }
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JPopupMenu.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JPopupMenu.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener, popupMenuListener);
    }

    protected void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$PopupMenuListener == null ? JPopupMenu.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
            }
            n -= 2;
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$PopupMenuListener == null ? JPopupMenu.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
            }
            n -= 2;
        }
    }

    protected void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$PopupMenuListener == null ? JPopupMenu.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n + 1]).popupMenuCanceled(popupMenuEvent);
            }
            n -= 2;
        }
    }

    boolean alwaysOnTop() {
        return true;
    }

    public void pack() {
        if (this.popup != null) {
            this.popup.pack();
        }
    }

    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        if (!bl) {
            this.getSelectionModel().clearSelection();
        } else if (this.isPopupMenu()) {
            if (this.getSubElements().length > 0) {
                MenuElement[] menuElementArray = new MenuElement[]{this, this.getSubElements()[0]};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            } else {
                MenuElement[] menuElementArray = new MenuElement[]{this};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            }
        }
        if (bl) {
            this.firePopupMenuWillBecomeVisible();
            this.popup = popupFactory.getPopup(this, this.invoker, this.desiredLocationX, this.desiredLocationY);
            this.popup.show(this.invoker);
        } else if (this.popup != null) {
            this.firePopupMenuWillBecomeInvisible();
            this.popup.hide();
            this.popup.removeComponent(this);
            this.popup = null;
        }
        if (this.accessibleContext != null) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }
        }
    }

    public boolean isVisible() {
        return this.popup != null;
    }

    public void setLocation(int n, int n2) {
        if (this.popup != null) {
            this.popup.setLocationOnScreen(n, n2);
        } else {
            this.desiredLocationX = n;
            this.desiredLocationY = n2;
        }
    }

    private boolean isPopupMenu() {
        return this.invoker != null && !(this.invoker instanceof JMenu);
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Component component) {
        Component component2 = this.invoker;
        this.invoker = component;
        if (component2 != this.invoker && this.ui != null) {
            this.ui.uninstallUI(this);
            this.ui.installUI(this);
        }
        this.invalidate();
    }

    public void show(Component component, int n, int n2) {
        this.setInvoker(component);
        Frame frame = JPopupMenu.getFrame(component);
        if (frame != this.frame && frame != null) {
            this.frame = frame;
            if (this.popup != null) {
                this.setVisible(false);
            }
        }
        if (component != null) {
            Point point = component.getLocationOnScreen();
            this.setLocation(point.x + n, point.y + n2);
        } else {
            this.setLocation(n, n2);
        }
        this.setVisible(true);
    }

    JPopupMenu getRootPopupMenu() {
        JPopupMenu jPopupMenu = this;
        while (jPopupMenu != null && !jPopupMenu.isPopupMenu() && jPopupMenu.getInvoker() != null && jPopupMenu.getInvoker().getParent() != null && jPopupMenu.getInvoker().getParent() instanceof JPopupMenu) {
            jPopupMenu = (JPopupMenu)jPopupMenu.getInvoker().getParent();
        }
        return jPopupMenu;
    }

    public Component getComponentAtIndex(int n) {
        return this.getComponent(n);
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void setPopupSize(Dimension dimension) {
        if (this.popup != null) {
            this.popup.setSize(dimension.width, dimension.height);
        }
    }

    public void setPopupSize(int n, int n2) {
        this.setPopupSize(new Dimension(n, n2));
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n);
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        this.paintBorder = bl;
        this.repaint();
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    boolean isSubPopupMenu(JPopupMenu jPopupMenu) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                JPopupMenu jPopupMenu2 = jMenu.getPopupMenu();
                if (jPopupMenu2 == jPopupMenu) {
                    return true;
                }
                if (jPopupMenu2.isSubPopupMenu(jPopupMenu)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private static Frame getFrame(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Frame) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Frame)component2;
    }

    protected String paramString() {
        String string = this.label != null ? this.label : "";
        String string2 = this.paintBorder ? "true" : "false";
        String string3 = this.margin != null ? this.margin.toString() : "";
        String string4 = this.isLightWeightPopupEnabled() ? "true" : "false";
        return super.paramString() + ",desiredLocationX=" + this.desiredLocationX + ",desiredLocationY=" + this.desiredLocationY + ",label=" + string + ",lightWeightPopupEnabled=" + string4 + ",margin=" + string3 + ",paintBorder=" + string2;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPopupMenu();
        }
        return this.accessibleContext;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector = new Vector();
        objectOutputStream.defaultWriteObject();
        if (this.invoker != null && this.invoker instanceof Serializable) {
            vector.addElement("invoker");
            vector.addElement(this.invoker);
        }
        if (this.popup != null && this.popup instanceof Serializable) {
            vector.addElement("popup");
            vector.addElement(this.popup);
        }
        if (this.frame != null && this.frame instanceof Serializable) {
            vector.addElement("frame");
            vector.addElement(this.frame);
        }
        objectOutputStream.writeObject(vector);
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("invoker")) {
            this.invoker = (Component)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("popup")) {
            this.popup = (Popup)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("frame")) {
            this.frame = (Frame)vector.elementAt(++n);
            ++n;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void menuSelectionChanged(boolean bl) {
        if (this.invoker instanceof JMenu) {
            JMenu jMenu = (JMenu)this.invoker;
            if (bl) {
                jMenu.setPopupMenuVisible(true);
            } else {
                jMenu.setPopupMenuVisible(false);
            }
        }
        if (this.isPopupMenu() && !bl) {
            this.setVisible(false);
        }
    }

    public MenuElement[] getSubElements() {
        Vector vector = new Vector();
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            if (component instanceof MenuElement) {
                vector.addElement(component);
            }
            ++n2;
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n2 = 0;
        n = vector.size();
        while (n2 < n) {
            menuElementArray[n2] = (MenuElement)vector.elementAt(n2);
            ++n2;
        }
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return this.getUI().isPopupTrigger(mouseEvent);
    }

    static void setPopupFactory(PopupFactory popupFactory) {
        JPopupMenu.popupFactory = popupFactory;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Separator
    extends JSeparator {
        public Separator() {
            super(0);
        }

        public String getUIClassID() {
            return "PopupMenuSeparatorUI";
        }
    }

    protected class AccessibleJPopupMenu
    extends JComponent.AccessibleJComponent {
        protected AccessibleJPopupMenu() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.setTarget(jMenuItem);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }

        public void setTarget(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }
    }
}

