/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AlphaCompositeContext;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;

public final class AlphaComposite
implements Composite {
    public static final int CLEAR = 1;
    public static final int SRC = 2;
    public static final int SRC_OVER = 3;
    public static final int DST_OVER = 4;
    public static final int SRC_IN = 5;
    public static final int DST_IN = 6;
    public static final int SRC_OUT = 7;
    public static final int DST_OUT = 8;
    public static final AlphaComposite Clear = new AlphaComposite(1);
    public static final AlphaComposite Src = new AlphaComposite(2);
    public static final AlphaComposite SrcOver = new AlphaComposite(3);
    public static final AlphaComposite DstOver = new AlphaComposite(4);
    public static final AlphaComposite SrcIn = new AlphaComposite(5);
    public static final AlphaComposite DstIn = new AlphaComposite(6);
    public static final AlphaComposite SrcOut = new AlphaComposite(7);
    public static final AlphaComposite DstOut = new AlphaComposite(8);
    private static final int MIN_RULE = 1;
    private static final int MAX_RULE = 8;
    float extraAlpha;
    int rule;

    private AlphaComposite(int n) {
        this(n, 1.0f);
    }

    private AlphaComposite(int n, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("alpha value out of range");
        }
        if (n < 1 || n > 8) {
            throw new IllegalArgumentException("unknown composite rule");
        }
        this.rule = n;
        this.extraAlpha = f;
    }

    public static AlphaComposite getInstance(int n) {
        switch (n) {
            case 1: {
                return Clear;
            }
            case 2: {
                return Src;
            }
            case 3: {
                return SrcOver;
            }
            case 4: {
                return DstOver;
            }
            case 5: {
                return SrcIn;
            }
            case 6: {
                return DstIn;
            }
            case 7: {
                return SrcOut;
            }
            case 8: {
                return DstOut;
            }
        }
        throw new IllegalArgumentException("unknown composite rule");
    }

    public static AlphaComposite getInstance(int n, float f) {
        if (f == 1.0f) {
            return AlphaComposite.getInstance(n);
        }
        return new AlphaComposite(n, f);
    }

    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        return new AlphaCompositeContext(colorModel, colorModel2, this.rule, this.extraAlpha);
    }

    public float getAlpha() {
        return this.extraAlpha;
    }

    public int getRule() {
        return this.rule;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.extraAlpha) * 31 + this.rule;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlphaComposite)) {
            return false;
        }
        AlphaComposite alphaComposite = (AlphaComposite)object;
        if (this.rule != alphaComposite.rule) {
            return false;
        }
        return this.extraAlpha == alphaComposite.extraAlpha;
    }
}

