/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.MenuItemUI;

public class JMenuItem
extends AbstractButton
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuItemUI";
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private boolean isMouseDragged = false;
    private KeyStroke accelerator;
    static /* synthetic */ Class class$javax$swing$event$MenuDragMouseListener;
    static /* synthetic */ Class class$javax$swing$event$MenuKeyListener;

    public JMenuItem() {
        this(null, null);
        this.setRequestFocusEnabled(false);
    }

    public JMenuItem(Icon icon) {
        this(null, icon);
        this.setRequestFocusEnabled(false);
    }

    public JMenuItem(String string) {
        this(string, null);
    }

    public JMenuItem(Action action) {
        this();
        this.setAction(action);
    }

    public JMenuItem(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
    }

    public JMenuItem(String string, int n) {
        this.setModel(new DefaultButtonModel());
        this.init(string, null);
        this.setMnemonic(n);
    }

    protected void init(String string, Icon icon) {
        if (string != null) {
            this.setText(string);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.addFocusListener(new MenuItemFocusListener());
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setHorizontalTextPosition(11);
        this.setHorizontalAlignment(10);
        this.updateUI();
    }

    public void setUI(MenuItemUI menuItemUI) {
        super.setUI(menuItemUI);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setArmed(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = buttonModel.isArmed();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
            }
        }
        if (buttonModel.isArmed() != bl) {
            buttonModel.setArmed(bl);
        }
    }

    public boolean isArmed() {
        ButtonModel buttonModel = this.getModel();
        return buttonModel.isArmed();
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.setArmed(false);
        }
        super.setEnabled(bl);
    }

    boolean alwaysOnTop() {
        return true;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        KeyStroke keyStroke2 = this.accelerator;
        this.accelerator = keyStroke;
        this.firePropertyChange("accelerator", keyStroke2, this.accelerator);
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    protected void configurePropertiesFromAction(Action action) {
        Integer n;
        this.setText(action != null ? (String)action.getValue("Name") : null);
        this.setIcon(action != null ? (Icon)action.getValue("SmallIcon") : null);
        this.setEnabled(action != null ? action.isEnabled() : true);
        if (action != null && (n = (Integer)action.getValue("MnemonicKey")) != null) {
            this.setMnemonic(n);
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, action){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                JMenuItem jMenuItem = (JMenuItem)this.getTarget();
                if (jMenuItem == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyChangeEvent.getPropertyName().equals("Name")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    jMenuItem.setText(string2);
                    jMenuItem.repaint();
                } else if (string.equals("enabled")) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    jMenuItem.setEnabled(bl);
                    jMenuItem.repaint();
                } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                    Icon icon = (Icon)propertyChangeEvent.getNewValue();
                    jMenuItem.setIcon(icon);
                    jMenuItem.invalidate();
                    jMenuItem.repaint();
                } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                    Integer n = (Integer)propertyChangeEvent.getNewValue();
                    jMenuItem.setMnemonic(n);
                    jMenuItem.invalidate();
                    jMenuItem.repaint();
                }
            }
        };
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        this.processMenuDragMouseEvent(new MenuDragMouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), menuElementArray, menuSelectionManager));
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        MenuKeyEvent menuKeyEvent = new MenuKeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), menuElementArray, menuSelectionManager);
        this.processMenuKeyEvent(menuKeyEvent);
        if (menuKeyEvent.isConsumed()) {
            keyEvent.consume();
        }
    }

    public void processMenuDragMouseEvent(MenuDragMouseEvent menuDragMouseEvent) {
        switch (menuDragMouseEvent.getID()) {
            case 504: {
                this.isMouseDragged = false;
                this.fireMenuDragMouseEntered(menuDragMouseEvent);
                break;
            }
            case 505: {
                this.isMouseDragged = false;
                this.fireMenuDragMouseExited(menuDragMouseEvent);
                break;
            }
            case 506: {
                this.isMouseDragged = true;
                this.fireMenuDragMouseDragged(menuDragMouseEvent);
                break;
            }
            case 502: {
                if (!this.isMouseDragged) break;
                this.fireMenuDragMouseReleased(menuDragMouseEvent);
                break;
            }
        }
    }

    public void processMenuKeyEvent(MenuKeyEvent menuKeyEvent) {
        switch (menuKeyEvent.getID()) {
            case 401: {
                this.fireMenuKeyPressed(menuKeyEvent);
                break;
            }
            case 402: {
                this.fireMenuKeyReleased(menuKeyEvent);
                break;
            }
            case 400: {
                this.fireMenuKeyTyped(menuKeyEvent);
                break;
            }
        }
    }

    protected void fireMenuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuDragMouseListener == null ? JMenuItem.class$("javax.swing.event.MenuDragMouseListener") : class$javax$swing$event$MenuDragMouseListener)) {
                ((MenuDragMouseListener)objectArray[n + 1]).menuDragMouseEntered(menuDragMouseEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuDragMouseListener == null ? JMenuItem.class$("javax.swing.event.MenuDragMouseListener") : class$javax$swing$event$MenuDragMouseListener)) {
                ((MenuDragMouseListener)objectArray[n + 1]).menuDragMouseExited(menuDragMouseEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuDragMouseListener == null ? JMenuItem.class$("javax.swing.event.MenuDragMouseListener") : class$javax$swing$event$MenuDragMouseListener)) {
                ((MenuDragMouseListener)objectArray[n + 1]).menuDragMouseDragged(menuDragMouseEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuDragMouseListener == null ? JMenuItem.class$("javax.swing.event.MenuDragMouseListener") : class$javax$swing$event$MenuDragMouseListener)) {
                ((MenuDragMouseListener)objectArray[n + 1]).menuDragMouseReleased(menuDragMouseEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuKeyPressed(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuKeyListener == null ? JMenuItem.class$("javax.swing.event.MenuKeyListener") : class$javax$swing$event$MenuKeyListener)) {
                ((MenuKeyListener)objectArray[n + 1]).menuKeyPressed(menuKeyEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuKeyReleased(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuKeyListener == null ? JMenuItem.class$("javax.swing.event.MenuKeyListener") : class$javax$swing$event$MenuKeyListener)) {
                ((MenuKeyListener)objectArray[n + 1]).menuKeyReleased(menuKeyEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuKeyTyped(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuKeyListener == null ? JMenuItem.class$("javax.swing.event.MenuKeyListener") : class$javax$swing$event$MenuKeyListener)) {
                ((MenuKeyListener)objectArray[n + 1]).menuKeyTyped(menuKeyEvent);
            }
            n -= 2;
        }
    }

    public void menuSelectionChanged(boolean bl) {
        this.setArmed(bl);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[0];
    }

    public Component getComponent() {
        return this;
    }

    public void addMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.add(class$javax$swing$event$MenuDragMouseListener == null ? (class$javax$swing$event$MenuDragMouseListener = JMenuItem.class$("javax.swing.event.MenuDragMouseListener")) : class$javax$swing$event$MenuDragMouseListener, menuDragMouseListener);
    }

    public void removeMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.remove(class$javax$swing$event$MenuDragMouseListener == null ? (class$javax$swing$event$MenuDragMouseListener = JMenuItem.class$("javax.swing.event.MenuDragMouseListener")) : class$javax$swing$event$MenuDragMouseListener, menuDragMouseListener);
    }

    public void addMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.add(class$javax$swing$event$MenuKeyListener == null ? (class$javax$swing$event$MenuKeyListener = JMenuItem.class$("javax.swing.event.MenuKeyListener")) : class$javax$swing$event$MenuKeyListener, menuKeyListener);
    }

    public void removeMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.remove(class$javax$swing$event$MenuKeyListener == null ? (class$javax$swing$event$MenuKeyListener = JMenuItem.class$("javax.swing.event.MenuKeyListener")) : class$javax$swing$event$MenuKeyListener, menuKeyListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getUIClassID().equals(uiClassID)) {
            this.updateUI();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuItem();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJMenuItem
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener {
        AccessibleJMenuItem() {
            JMenuItem.this.addChangeListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }
    }

    private static class MenuItemFocusListener
    implements FocusListener,
    Serializable {
        private MenuItemFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            JMenuItem jMenuItem = (JMenuItem)focusEvent.getSource();
            if (jMenuItem.isFocusPainted()) {
                jMenuItem.repaint();
            }
        }
    }
}

