/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.OutputStreamCounter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfEncryptionStream;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PdfStream
extends PdfDictionary {
    protected boolean compressed = false;
    protected ByteArrayOutputStream streamBytes = null;
    protected InputStream inputStream;
    protected PdfIndirectReference ref;
    protected int inputStreamLength = -1;
    protected PdfWriter writer;
    protected int rawLength;
    static final byte[] STARTSTREAM = DocWriter.getISOBytes("stream\n");
    static final byte[] ENDSTREAM = DocWriter.getISOBytes("\nendstream");
    static final int SIZESTREAM = STARTSTREAM.length + ENDSTREAM.length;

    public PdfStream(byte[] byArray) {
        this.type = 7;
        this.bytes = byArray;
        this.rawLength = byArray.length;
        this.put(PdfName.LENGTH, new PdfNumber(byArray.length));
    }

    public PdfStream(InputStream inputStream, PdfWriter pdfWriter) {
        this.type = 7;
        this.inputStream = inputStream;
        this.writer = pdfWriter;
        this.ref = pdfWriter.getPdfIndirectReference();
        this.put(PdfName.LENGTH, this.ref);
    }

    protected PdfStream() {
        this.type = 7;
    }

    public void writeLength() throws IOException {
        if (this.inputStream == null) {
            throw new UnsupportedOperationException("writeLength() can only be called in a contructed PdfStream(InputStream,PdfWriter).");
        }
        if (this.inputStreamLength == -1) {
            throw new IOException("writeLength() can only be called after output of the stream body.");
        }
        this.writer.addToBody((PdfObject)new PdfNumber(this.inputStreamLength), this.ref, false);
    }

    public int getRawLength() {
        return this.rawLength;
    }

    public void flateCompress() {
        if (!Document.compress) {
            return;
        }
        if (this.compressed) {
            return;
        }
        if (this.inputStream != null) {
            this.compressed = true;
            return;
        }
        PdfObject pdfObject = this.get(PdfName.FILTER);
        if (pdfObject != null) {
            if (pdfObject.isName() && ((PdfName)pdfObject).compareTo(PdfName.FLATEDECODE) == 0) {
                return;
            }
            if (pdfObject.isArray() && ((PdfArray)pdfObject).contains(PdfName.FLATEDECODE)) {
                return;
            }
            throw new RuntimeException("Stream could not be compressed: filter is not a name or array.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(deflaterOutputStream);
            } else {
                deflaterOutputStream.write(this.bytes);
            }
            deflaterOutputStream.close();
            this.streamBytes = byteArrayOutputStream;
            this.bytes = null;
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            if (pdfObject == null) {
                this.put(PdfName.FILTER, PdfName.FLATEDECODE);
            } else {
                PdfArray pdfArray = new PdfArray(pdfObject);
                pdfArray.add(PdfName.FLATEDECODE);
                this.put(PdfName.FILTER, pdfArray);
            }
            this.compressed = true;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected void superToPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        super.toPdf(pdfWriter, outputStream);
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        if (this.inputStream != null && this.compressed) {
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        }
        this.superToPdf(pdfWriter, outputStream);
        outputStream.write(STARTSTREAM);
        PdfEncryption pdfEncryption = null;
        if (pdfWriter != null) {
            pdfEncryption = pdfWriter.getEncryption();
        }
        if (pdfEncryption != null) {
            pdfEncryption.prepareKey();
        }
        if (this.inputStream != null) {
            int n;
            OutputStreamCounter outputStreamCounter;
            this.rawLength = 0;
            DeflaterOutputStream deflaterOutputStream = null;
            PdfEncryptionStream pdfEncryptionStream = null;
            OutputStream outputStream2 = outputStreamCounter = new OutputStreamCounter(outputStream);
            if (pdfEncryption != null) {
                pdfEncryptionStream = new PdfEncryptionStream(outputStream2, pdfEncryption);
                outputStream2 = pdfEncryptionStream;
            }
            if (this.compressed) {
                deflaterOutputStream = new DeflaterOutputStream(outputStream2, new Deflater(9), 32768);
                outputStream2 = deflaterOutputStream;
            }
            byte[] byArray = new byte[65536];
            while ((n = this.inputStream.read(byArray)) > 0) {
                ((OutputStream)outputStream2).write(byArray, 0, n);
                this.rawLength += n;
            }
            if (deflaterOutputStream != null) {
                deflaterOutputStream.finish();
            }
            this.inputStreamLength = outputStreamCounter.getCounter();
        } else if (pdfEncryption == null) {
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(outputStream);
            } else {
                outputStream.write(this.bytes);
            }
        } else {
            byte[] byArray;
            if (this.streamBytes != null) {
                byArray = this.streamBytes.toByteArray();
                pdfEncryption.encryptRC4(byArray);
            } else {
                byArray = new byte[this.bytes.length];
                pdfEncryption.encryptRC4(this.bytes, byArray);
            }
            outputStream.write(byArray);
        }
        outputStream.write(ENDSTREAM);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        if (this.streamBytes != null) {
            this.streamBytes.writeTo(outputStream);
        } else if (this.bytes != null) {
            outputStream.write(this.bytes);
        }
    }
}

