/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class ComponentColorModel
extends ColorModel {
    private boolean is_LinearRGB;
    private boolean is_LinearGray;
    private boolean is_ICCGray;
    private byte[] tosRGB8LUT;
    private byte[] fromsRGB8LUT8;
    private short[] fromsRGB8LUT16;
    private byte[] fromLinearGray16ToOtherGray8LUT;
    private short[] fromLinearGray16ToOtherGray16LUT;

    public ComponentColorModel(ColorSpace colorSpace, int[] nArray, boolean bl, boolean bl2, int n, int n2) {
        super(DataBuffer.getDataTypeSize(n2) * nArray.length, nArray, colorSpace, bl, bl2, n, n2);
        if (!this.is_sRGB) {
            this.setupLUTs();
        }
    }

    private void setupLUTs() {
        if (ColorModel.isLinearRGBspace(this.colorSpace)) {
            this.is_LinearRGB = true;
            if (this.transferType == 0) {
                this.tosRGB8LUT = ColorModel.getLinearRGB8TosRGB8LUT();
                this.fromsRGB8LUT8 = ColorModel.getsRGB8ToLinearRGB8LUT();
            } else {
                this.tosRGB8LUT = ColorModel.getLinearRGB16TosRGB8LUT();
                this.fromsRGB8LUT16 = ColorModel.getsRGB8ToLinearRGB16LUT();
            }
        } else if (this.colorSpaceType == 6 && this.colorSpace instanceof ICC_ColorSpace) {
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)this.colorSpace;
            this.is_ICCGray = true;
            this.fromsRGB8LUT16 = ColorModel.getsRGB8ToLinearRGB16LUT();
            if (ColorModel.isLinearGRAYspace(iCC_ColorSpace)) {
                this.is_LinearGray = true;
                this.tosRGB8LUT = this.transferType == 0 ? ColorModel.getGray8TosRGB8LUT(iCC_ColorSpace) : ColorModel.getGray16TosRGB8LUT(iCC_ColorSpace);
            } else if (this.transferType == 0) {
                this.tosRGB8LUT = ColorModel.getGray8TosRGB8LUT(iCC_ColorSpace);
                this.fromLinearGray16ToOtherGray8LUT = ColorModel.getLinearGray16ToOtherGray8LUT(iCC_ColorSpace);
            } else {
                this.tosRGB8LUT = ColorModel.getGray16TosRGB8LUT(iCC_ColorSpace);
                this.fromLinearGray16ToOtherGray16LUT = ColorModel.getLinearGray16ToOtherGray16LUT(iCC_ColorSpace);
            }
        }
    }

    public int getRed(int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        float[] fArray = new float[]{(float)n / (float)((1 << this.nBits[0]) - 1)};
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[0] * 255.0f + 0.5f);
    }

    public int getGreen(int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        float[] fArray = new float[]{(float)n / (float)((1 << this.nBits[0]) - 1)};
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[1] * 255.0f + 0.5f);
    }

    public int getBlue(int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        float[] fArray = new float[]{(float)n / (float)((1 << this.nBits[0]) - 1)};
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[2] * 255.0f + 0.5f);
    }

    public int getAlpha(int n) {
        if (!this.supportsAlpha) {
            return 255;
        }
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        return (int)((float)n / (float)((1 << this.nBits[0]) - 1) * 255.0f + 0.5f);
    }

    public int getRGB(int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n) << 0;
    }

    private int getRGBComponent(Object object, int n) {
        if (this.is_sRGB) {
            return this.extractComponent(object, n, 8);
        }
        if (this.is_LinearRGB) {
            int n2 = this.extractComponent(object, n, 16);
            return this.tosRGB8LUT[n2] & 0xFF;
        }
        if (this.is_ICCGray) {
            int n3 = this.extractComponent(object, 0, 16);
            return this.tosRGB8LUT[n3] & 0xFF;
        }
        float[] fArray = this.getNormalizedComponents(object, null, 0);
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[n] * 255.0f + 0.5f);
    }

    private int extractComponent(Object object, int n, int n2) {
        int n3;
        boolean bl = this.supportsAlpha && this.isAlphaPremultiplied;
        int n4 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n3 = byArray[n] & 0xFF;
                n2 = 8;
                if (!bl) break;
                n4 = byArray[this.numColorComponents] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n3 = sArray[n] & 0xFFFF;
                if (!bl) break;
                n4 = sArray[this.numColorComponents] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n3 = nArray[n];
                if (!bl) break;
                n4 = nArray[this.numColorComponents];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (bl) {
            if (n4 != 0) {
                float f = (1 << n2) - 1;
                float f2 = (float)n3 / (float)((1 << this.nBits[n]) - 1);
                float f3 = (float)((1 << this.nBits[this.numColorComponents]) - 1) / (float)n4;
                return (int)(f2 * f3 * f + 0.5f);
            }
            return 0;
        }
        if (this.nBits[n] != n2) {
            float f = (1 << n2) - 1;
            float f4 = (float)n3 / (float)((1 << this.nBits[n]) - 1);
            return (int)(f4 * f + 0.5f);
        }
        return n3;
    }

    public int getRed(Object object) {
        return this.getRGBComponent(object, 0);
    }

    public int getGreen(Object object) {
        return this.getRGBComponent(object, 1);
    }

    public int getBlue(Object object) {
        return this.getRGBComponent(object, 2);
    }

    public int getAlpha(Object object) {
        if (!this.supportsAlpha) {
            return 255;
        }
        int n = 0;
        int n2 = this.numColorComponents;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[n2] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[n2] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[n2];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (this.nBits[n2] == 8) {
            return n;
        }
        return (int)((float)n / (float)((1 << this.nBits[n2]) - 1) * 255.0f + 0.5f);
    }

    private float getNormAlpha(int[] nArray) {
        return (float)nArray[this.numColorComponents] / ((float)(1 << this.nBits[this.numColorComponents]) - 1.0f);
    }

    private float[] getNormalizedComponents(Object object, float[] fArray, int n) {
        float f;
        if (fArray == null) {
            fArray = new float[this.numComponents + n];
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n2 = 0;
                int n3 = n;
                while (n2 < this.numComponents) {
                    fArray[n3] = (float)(byArray[n2] & 0xFF) / (float)((1 << this.nBits[n2]) - 1);
                    ++n2;
                    ++n3;
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                int n4 = 0;
                int n5 = n;
                while (n4 < this.numComponents) {
                    fArray[n5] = (float)(sArray[n4] & 0xFFFF) / (float)((1 << this.nBits[n4]) - 1);
                    ++n4;
                    ++n5;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n6 = 0;
                int n7 = n;
                while (n6 < this.numComponents) {
                    fArray[n7] = (float)nArray[n6] / (float)((1 << this.nBits[n6]) - 1);
                    ++n6;
                    ++n7;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (this.supportsAlpha && this.isAlphaPremultiplied && (f = fArray[this.numColorComponents + n]) != 0.0f) {
            float f2 = 1.0f / f;
            int n8 = n;
            while (n8 < this.numColorComponents + n) {
                int n9 = n8++;
                fArray[n9] = fArray[n9] * f2;
            }
        }
        return fArray;
    }

    public int getRGB(Object object) {
        if (this.colorSpaceType == 6) {
            int n = this.getRed(object);
            return this.getAlpha(object) << 24 | n << 16 | n << 8 | n;
        }
        if (!this.is_sRGB) {
            int[] nArray;
            if (object instanceof int[]) {
                nArray = (int[])object;
            } else {
                nArray = DataBuffer.toIntArray(object);
                if (nArray == null) {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
            float[] fArray = this.getNormalizedComponents(nArray, 0, null, 0);
            float[] fArray2 = this.colorSpace.toRGB(fArray);
            return this.getAlpha(object) << 24 | (int)(fArray2[0] * 255.0f) << 16 | (int)(fArray2[1] * 255.0f) << 8 | (int)(fArray2[2] * 255.0f) << 0;
        }
        return this.getAlpha(object) << 24 | this.getRed(object) << 16 | this.getGreen(object) << 8 | this.getBlue(object);
    }

    public Object getDataElements(int n, Object object) {
        int n2;
        float f;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int[] nArray = this.transferType == 3 && object != null ? (int[])object : new int[this.numComponents];
        if (this.is_sRGB || this.is_LinearRGB) {
            int n6;
            if (this.is_LinearRGB) {
                if (this.transferType == 0) {
                    n3 = this.fromsRGB8LUT8[n3] & 0xFF;
                    n4 = this.fromsRGB8LUT8[n4] & 0xFF;
                    n5 = this.fromsRGB8LUT8[n5] & 0xFF;
                    n6 = 8;
                    f = 0.003921569f;
                } else {
                    n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                    n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                    n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                    n6 = 16;
                    f = 1.5259022E-5f;
                }
            } else {
                n6 = 8;
                f = 0.003921569f;
            }
            if (this.supportsAlpha) {
                n2 = n >> 24 & 0xFF;
                nArray[3] = this.nBits[3] == 8 ? n2 : (int)((float)n2 * 0.003921569f * (float)((1 << this.nBits[3]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f *= (float)n2 * 0.003921569f;
                    n6 = -1;
                }
            }
            nArray[0] = this.nBits[0] == n6 ? n3 : (int)((float)n3 * f * (float)((1 << this.nBits[0]) - 1) + 0.5f);
            nArray[1] = this.nBits[1] == n6 ? n4 : (int)((float)n4 * f * (float)((1 << this.nBits[1]) - 1) + 0.5f);
            nArray[2] = this.nBits[2] == n6 ? n5 : (int)((float)n5 * f * (float)((1 << this.nBits[2]) - 1) + 0.5f);
        } else if (this.is_LinearGray) {
            n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
            float f2 = (0.2125f * (float)n3 + 0.7154f * (float)n4 + 0.0721f * (float)n5) / 65535.0f;
            if (this.supportsAlpha) {
                n2 = n >> 24 & 0xFF;
                nArray[1] = this.nBits[1] == 8 ? n2 : (int)((float)n2 * 0.003921569f * (float)((1 << this.nBits[1]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f2 *= (float)n2 * 0.003921569f;
                }
            }
            nArray[0] = (int)(f2 * (float)((1 << this.nBits[0]) - 1) + 0.5f);
        } else if (this.is_ICCGray) {
            n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
            int n7 = (int)(0.2125f * (float)n3 + 0.7154f * (float)n4 + 0.0721f * (float)n5 + 0.5f);
            f = (float)(this.fromLinearGray16ToOtherGray16LUT[n7] & 0xFFFF) / 65535.0f;
            if (this.supportsAlpha) {
                n2 = n >> 24 & 0xFF;
                nArray[1] = this.nBits[1] == 8 ? n2 : (int)((float)n2 * 0.003921569f * (float)((1 << this.nBits[1]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f *= (float)n2 * 0.003921569f;
                }
            }
            nArray[0] = (int)(f * (float)((1 << this.nBits[0]) - 1) + 0.5f);
        } else {
            int n8;
            float[] fArray = new float[3];
            f = 0.003921569f;
            fArray[0] = (float)n3 * f;
            fArray[1] = (float)n4 * f;
            fArray[2] = (float)n5 * f;
            fArray = this.colorSpace.fromRGB(fArray);
            if (this.supportsAlpha) {
                n2 = n >> 24 & 0xFF;
                nArray[this.numColorComponents] = this.nBits[this.numColorComponents] == 8 ? n2 : (int)((float)n2 * f * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f *= (float)n2;
                    n8 = 0;
                    while (n8 < this.numColorComponents) {
                        int n9 = n8++;
                        fArray[n9] = fArray[n9] * f;
                    }
                }
            }
            n8 = 0;
            while (n8 < this.numColorComponents) {
                nArray[n8] = (int)(fArray[n8] * (float)((1 << this.nBits[n8]) - 1) + 0.5f);
                ++n8;
            }
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = object == null ? new byte[this.numComponents] : (byte[])object;
                int n10 = 0;
                while (n10 < this.numComponents) {
                    byArray[n10] = (byte)(0xFF & nArray[n10]);
                    ++n10;
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                int n11 = 0;
                while (n11 < this.numComponents) {
                    sArray[n11] = (short)(nArray[n11] & 0xFFFF);
                    ++n11;
                }
                return sArray;
            }
            case 3: {
                if (this.maxBits > 23) {
                    int n12 = 0;
                    while (n12 < this.numComponents) {
                        if (nArray[n12] > (1 << this.nBits[n12]) - 1) {
                            nArray[n12] = (1 << this.nBits[n12]) - 1;
                        }
                        ++n12;
                    }
                }
                return nArray;
            }
        }
        throw new IllegalArgumentException("This method has not been implemented for transferType " + this.transferType);
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (nArray == null) {
            nArray = new int[n2 + 1];
        }
        nArray[n2 + 0] = n & (1 << this.nBits[0]) - 1;
        return nArray;
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        int[] nArray2;
        if (object instanceof int[]) {
            nArray2 = (int[])object;
        } else {
            nArray2 = DataBuffer.toIntArray(object);
            if (nArray2 == null) {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (nArray2.length < this.numComponents) {
            throw new IllegalArgumentException("Length of pixel array < number of components in model");
        }
        if (nArray == null) {
            nArray = new int[n + this.numComponents];
        } else if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Length of components array < number of components in model");
        }
        System.arraycopy(nArray2, 0, nArray, n, this.numComponents);
        return nArray;
    }

    public int getDataElement(int[] nArray, int n) {
        if (this.numComponents == 1) {
            return nArray[n + 0];
        }
        throw new IllegalArgumentException("This model returns " + this.numComponents + " elements in the pixel array.");
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Component array too small (should be " + this.numComponents);
        }
        switch (this.transferType) {
            case 3: {
                int[] nArray2 = object == null ? new int[nArray.length] : (int[])object;
                System.arraycopy(nArray, n, nArray2, 0, this.numComponents);
                return nArray2;
            }
            case 0: {
                byte[] byArray = object == null ? new byte[nArray.length] : (byte[])object;
                int n2 = 0;
                while (n2 < this.numComponents) {
                    byArray[n2] = (byte)(nArray[n + n2] & 0xFF);
                    ++n2;
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[nArray.length] : (short[])object;
                int n3 = 0;
                while (n3 < this.numComponents) {
                    sArray[n3] = (short)(nArray[n + n3] & 0xFFFF);
                    ++n3;
                }
                return sArray;
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        block36: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            block35: {
                if (!this.supportsAlpha || this.isAlphaPremultiplied == bl) {
                    return this;
                }
                n5 = writableRaster.getWidth();
                n4 = writableRaster.getHeight();
                n3 = writableRaster.getNumBands() - 1;
                n2 = writableRaster.getMinX();
                n = writableRaster.getMinY();
                if (!bl) break block35;
                switch (this.transferType) {
                    case 0: {
                        byte[] byArray = null;
                        int n6 = 0;
                        while (n6 < n4) {
                            int n7 = n2;
                            int n8 = 0;
                            while (n8 < n5) {
                                int n9 = (byArray = (byte[])writableRaster.getDataElements(n7, n, byArray))[n3] & 0xFF;
                                if (n9 != 0) {
                                    int n10 = 0;
                                    while (n10 < n3) {
                                        byArray[n10] = (byte)((byArray[n10] & 0xFF) * n9);
                                        ++n10;
                                    }
                                    writableRaster.setDataElements(n7, n, byArray);
                                }
                                ++n8;
                                ++n7;
                            }
                            ++n6;
                            ++n;
                        }
                        break block36;
                    }
                    case 1: {
                        short[] sArray = null;
                        int n11 = 0;
                        while (n11 < n4) {
                            int n12 = n2;
                            int n13 = 0;
                            while (n13 < n5) {
                                int n14 = (sArray = (short[])writableRaster.getDataElements(n12, n, sArray))[n3] & 0xFFFF;
                                if (n14 != 0) {
                                    int n15 = 0;
                                    while (n15 < n3) {
                                        sArray[n15] = (short)((sArray[n15] & 0xFFFF) * n14);
                                        ++n15;
                                    }
                                    writableRaster.setDataElements(n12, n, sArray);
                                }
                                ++n13;
                                ++n12;
                            }
                            ++n11;
                            ++n;
                        }
                        break block36;
                    }
                    case 3: {
                        int[] nArray = null;
                        int n16 = 0;
                        while (n16 < n4) {
                            int n17 = n2;
                            int n18 = 0;
                            while (n18 < n5) {
                                int n19 = (nArray = (int[])writableRaster.getDataElements(n17, n, nArray))[n3];
                                if (n19 != 0) {
                                    int n20 = 0;
                                    while (n20 < n3) {
                                        int n21 = n20++;
                                        nArray[n21] = nArray[n21] * n19;
                                    }
                                    writableRaster.setDataElements(n17, n, nArray);
                                }
                                ++n18;
                                ++n17;
                            }
                            ++n16;
                            ++n;
                        }
                        break block36;
                    }
                    default: {
                        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                    }
                }
            }
            switch (this.transferType) {
                case 0: {
                    int n22 = 0;
                    while (n22 < n4) {
                        int n23 = n2;
                        int n24 = 0;
                        while (n24 < n5) {
                            byte[] byArray = null;
                            byArray = (byte[])writableRaster.getDataElements(n23, n, byArray);
                            int n25 = byArray[n3] & 0xFF;
                            int n26 = 0;
                            while (n26 < n3) {
                                if (n25 != 0) {
                                    byArray[n26] = (byte)((byArray[n26] & 0xFF) / n25);
                                }
                                ++n26;
                            }
                            writableRaster.setDataElements(n23, n, byArray);
                            ++n24;
                            ++n23;
                        }
                        ++n22;
                        ++n;
                    }
                    break;
                }
                case 1: {
                    int n27 = 0;
                    while (n27 < n4) {
                        int n28 = n2;
                        int n29 = 0;
                        while (n29 < n5) {
                            short[] sArray = null;
                            sArray = (short[])writableRaster.getDataElements(n28, n, sArray);
                            int n30 = sArray[n3] & 0xFFFF;
                            int n31 = 0;
                            while (n31 < n3) {
                                if (n30 != 0) {
                                    sArray[n31] = (short)((sArray[n31] & 0xFFFF) / n30);
                                }
                                ++n31;
                            }
                            writableRaster.setDataElements(n28, n, sArray);
                            ++n29;
                            ++n28;
                        }
                        ++n27;
                        ++n;
                    }
                    break;
                }
                case 3: {
                    int n32 = 0;
                    while (n32 < n4) {
                        int n33 = n2;
                        int n34 = 0;
                        while (n34 < n5) {
                            int[] nArray = null;
                            nArray = (int[])writableRaster.getDataElements(n33, n, nArray);
                            int n35 = nArray[n3];
                            int n36 = 0;
                            while (n36 < n3) {
                                if (n35 != 0) {
                                    int n37 = n36;
                                    nArray[n37] = nArray[n37] / n35;
                                }
                                ++n36;
                            }
                            writableRaster.setDataElements(n33, n, nArray);
                            ++n34;
                            ++n33;
                        }
                        ++n32;
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
        }
        return new ComponentColorModel(this.colorSpace, this.nBits, this.supportsAlpha, bl, this.transparency, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        boolean bl = true;
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModel.getNumBands() != this.getNumComponents()) {
                return false;
            }
            int n = 0;
            while (n < this.nBits.length) {
                if (sampleModel.getSampleSize(n) < this.nBits[n]) {
                    bl = false;
                }
                ++n;
            }
        } else {
            return false;
        }
        return raster.getTransferType() == this.transferType && bl;
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        int n3 = n * n2 * this.numComponents;
        WritableRaster writableRaster = null;
        writableRaster = Raster.createInterleavedRaster(this.transferType, n, n2, this.numComponents, null);
        return writableRaster;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = new int[this.numComponents];
        int n3 = 0;
        while (n3 < this.numComponents) {
            nArray[n3] = n3;
            ++n3;
        }
        return new PixelInterleavedSampleModel(this.transferType, n, n2, this.numComponents, n * this.numComponents, nArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return sampleModel.getTransferType() == this.transferType;
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int[] nArray = new int[]{writableRaster.getNumBands() - 1};
        return writableRaster.createWritableChild(n, n2, writableRaster.getWidth(), writableRaster.getHeight(), n, n2, nArray);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return object.getClass() == this.getClass();
    }
}

