/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicMenuBarUI
extends MenuBarUI {
    protected JMenuBar menuBar = null;
    protected ContainerListener containerListener;
    protected ChangeListener changeListener;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.menuBar = (JMenuBar)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            if (BasicGraphicsUtils.isLeftToRight(this.menuBar)) {
                this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 0));
            } else {
                this.menuBar.setLayout(new RightToLeftMenuLayout());
            }
        }
        this.menuBar.setOpaque(true);
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
    }

    protected void installListeners() {
        this.containerListener = this.createContainerListener();
        this.changeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            JMenu jMenu = this.menuBar.getMenu(n);
            if (jMenu != null) {
                jMenu.getModel().addChangeListener(this.changeListener);
            }
            ++n;
        }
        this.menuBar.addContainerListener(this.containerListener);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuBar, actionMap);
    }

    InputMap getInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIManager.get("MenuBar.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.menuBar, objectArray);
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("MenuBar.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("MenuBar.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("takeFocus", new TakeFocus());
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    protected void uninstallDefaults() {
        if (this.menuBar != null) {
            LookAndFeel.uninstallBorder(this.menuBar);
        }
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            JMenu jMenu = this.menuBar.getMenu(n);
            if (jMenu != null) {
                jMenu.getModel().removeChangeListener(this.changeListener);
            }
            ++n;
        }
        this.containerListener = null;
        this.changeListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, null);
        SwingUtilities.replaceUIActionMap(this.menuBar, null);
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler();
    }

    protected ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    private static class RightToLeftMenuLayout
    extends FlowLayout
    implements UIResource {
        private RightToLeftMenuLayout() {
            super(3, 0, 0);
        }
    }

    private static class TakeFocus
    extends AbstractAction {
        TakeFocus() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuBar jMenuBar = (JMenuBar)actionEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = jMenuBar.getMenu(0);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().addChangeListener(BasicMenuBarUI.this.changeListener);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().removeChangeListener(BasicMenuBarUI.this.changeListener);
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation") && BasicMenuBarUI.this.menuBar.getLayout() instanceof UIResource) {
                if (BasicGraphicsUtils.isLeftToRight(BasicMenuBarUI.this.menuBar)) {
                    BasicMenuBarUI.this.menuBar.setLayout(new DefaultMenuLayout(BasicMenuBarUI.this.menuBar, 0));
                } else {
                    BasicMenuBarUI.this.menuBar.setLayout(new RightToLeftMenuLayout());
                }
            }
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = 0;
            int n2 = BasicMenuBarUI.this.menuBar.getMenuCount();
            while (n < n2) {
                JMenu jMenu = BasicMenuBarUI.this.menuBar.getMenu(n);
                if (jMenu != null && jMenu.isSelected()) {
                    BasicMenuBarUI.this.menuBar.getSelectionModel().setSelectedIndex(n);
                    break;
                }
                ++n;
            }
        }
    }
}

