/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class PdfArray
extends PdfObject {
    protected ArrayList arrayList;

    public PdfArray() {
        super(5);
        this.arrayList = new ArrayList();
    }

    public PdfArray(PdfObject pdfObject) {
        super(5);
        this.arrayList = new ArrayList();
        this.arrayList.add(pdfObject);
    }

    public PdfArray(float[] fArray) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(fArray);
    }

    public PdfArray(int[] nArray) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(nArray);
    }

    public PdfArray(PdfArray pdfArray) {
        super(5);
        this.arrayList = new ArrayList(pdfArray.getArrayList());
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        PdfObject pdfObject;
        outputStream.write(91);
        Iterator iterator = this.arrayList.iterator();
        int n = 0;
        if (iterator.hasNext()) {
            pdfObject = (PdfObject)iterator.next();
            pdfObject.toPdf(pdfWriter, outputStream);
        }
        while (iterator.hasNext()) {
            pdfObject = (PdfObject)iterator.next();
            n = pdfObject.type();
            if (n != 5 && n != 6 && n != 4 && n != 3) {
                outputStream.write(32);
            }
            pdfObject.toPdf(pdfWriter, outputStream);
        }
        outputStream.write(93);
    }

    public ArrayList getArrayList() {
        return this.arrayList;
    }

    public int size() {
        return this.arrayList.size();
    }

    public boolean add(PdfObject pdfObject) {
        return this.arrayList.add(pdfObject);
    }

    public boolean add(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.arrayList.add(new PdfNumber(fArray[i]));
        }
        return true;
    }

    public boolean add(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.arrayList.add(new PdfNumber(nArray[i]));
        }
        return true;
    }

    public void addFirst(PdfObject pdfObject) {
        this.arrayList.add(0, pdfObject);
    }

    public boolean contains(PdfObject pdfObject) {
        return this.arrayList.contains(pdfObject);
    }

    public ListIterator listIterator() {
        return this.arrayList.listIterator();
    }
}

