/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.url.ldap.ldapURLContext;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;

public final class ldapURLContextFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object == null) {
            return new ldapURLContext(hashtable);
        }
        if (object instanceof String) {
            return ldapURLContextFactory.getUsingURL((String)object, hashtable);
        }
        if (object instanceof String[]) {
            return ldapURLContextFactory.getUsingURLs((String[])object, hashtable);
        }
        throw new IllegalArgumentException("ldapURLContextFactory.getObjectInstance: argument must be an LDAP URL String or array of them");
    }

    static ResolveResult getUsingURLIgnoreRootDN(String string, Hashtable hashtable) throws NamingException {
        LdapURL ldapURL = new LdapURL(string);
        LdapCtx ldapCtx = new LdapCtx("", ldapURL.getHost(), ldapURL.getPort(), hashtable);
        String string2 = ldapURL.getDN() != null ? ldapURL.getDN() : "";
        CompositeName compositeName = new CompositeName();
        if (!"".equals(string2)) {
            compositeName.add(string2);
        }
        return new ResolveResult((Object)ldapCtx, compositeName);
    }

    private static DirContext getUsingURL(String string, Hashtable hashtable) throws NamingException {
        LdapURL ldapURL = new LdapURL(string);
        String string2 = ldapURL.getDN() != null ? ldapURL.getDN() : "";
        return new LdapCtx(string2, ldapURL.getHost(), ldapURL.getPort(), hashtable);
    }

    private static DirContext getUsingURLs(String[] stringArray, Hashtable hashtable) throws NamingException {
        NamingException namingException = null;
        int n = 0;
        while (n < stringArray.length) {
            try {
                return ldapURLContextFactory.getUsingURL(stringArray[n], hashtable);
            }
            catch (NamingException namingException2) {
                namingException = namingException2;
                ++n;
            }
        }
        throw namingException;
    }
}

