/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Bidi;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.GlyphPainter2;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

class TextLayoutStrategy
extends FlowView.FlowStrategy {
    private LineBreakMeasurer measurer;
    private AttributedSegment text = new AttributedSegment();

    public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        this.sync(flowView);
        super.insertUpdate(flowView, documentEvent, rectangle);
    }

    public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        this.sync(flowView);
        super.removeUpdate(flowView, documentEvent, rectangle);
    }

    public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        this.sync(flowView);
        super.changedUpdate(flowView, documentEvent, rectangle);
    }

    public void layout(FlowView flowView) {
        super.layout(flowView);
    }

    protected int layoutRow(FlowView flowView, int n, int n2) {
        int n3;
        int n4 = super.layoutRow(flowView, n, n2);
        View view = flowView.getView(n);
        Document document = flowView.getDocument();
        Object object = document.getProperty("i18n");
        if (object != null && object.equals(Boolean.TRUE) && (n3 = view.getViewCount()) > 1) {
            AbstractDocument abstractDocument = (AbstractDocument)flowView.getDocument();
            Element element = abstractDocument.getBidiRootElement();
            byte[] byArray = new byte[n3];
            Object[] objectArray = new View[n3];
            int n5 = 0;
            while (n5 < n3) {
                View view2 = view.getView(n5);
                int n6 = element.getElementIndex(view2.getStartOffset());
                Element element2 = element.getElement(n6);
                byArray[n5] = (byte)StyleConstants.getBidiLevel(element2.getAttributes());
                objectArray[n5] = view2;
                ++n5;
            }
            Bidi.reorderVisually(byArray, objectArray);
            view.replace(0, n3, (View[])objectArray);
        }
        return n4;
    }

    protected void adjustRow(FlowView flowView, int n, int n2, int n3) {
    }

    protected View createView(FlowView flowView, int n, int n2, int n3) {
        View view = this.getLogicalView(flowView);
        View view2 = flowView.getView(n3);
        boolean bl = view2.getViewCount() != 0;
        int n4 = view.getViewIndex(n, Position.Bias.Forward);
        View view3 = view.getView(n4);
        int n5 = this.getLimitingOffset(view3, n, n2, bl);
        if (n5 == n) {
            return null;
        }
        View view4 = n == view3.getStartOffset() && n5 == view3.getEndOffset() ? view3 : view3.createFragment(n, n5);
        if (view4 instanceof GlyphView && this.measurer != null) {
            Segment segment;
            char c;
            boolean bl2 = false;
            int n6 = view4.getStartOffset();
            int n7 = view4.getEndOffset();
            if (n7 - n6 == 1 && (c = (segment = ((GlyphView)view4).getText(n6, n7)).first()) == '\t') {
                bl2 = true;
            }
            Cloneable cloneable = segment = bl2 ? null : this.measurer.nextLayout(n2, this.text.toIteratorIndex(n5), bl);
            if (segment != null) {
                ((GlyphView)view4).setGlyphPainter(new GlyphPainter2((TextLayout)((Object)segment)));
            }
        }
        return view4;
    }

    int getLimitingOffset(View view, int n, int n2, boolean bl) {
        Object object;
        Element element;
        int n3 = view.getEndOffset();
        Document document = view.getDocument();
        if (document instanceof AbstractDocument && (element = ((AbstractDocument)(object = (AbstractDocument)document)).getBidiRootElement()).getElementCount() > 1) {
            int n4 = element.getElementIndex(n);
            Element element2 = element.getElement(n4);
            n3 = Math.min(element2.getEndOffset(), n3);
        }
        if (view instanceof GlyphView) {
            object = ((GlyphView)view).getText(n, n3);
            char c = ((Segment)object).first();
            if (c == '\t') {
                n3 = n + 1;
            } else {
                c = ((Segment)object).next();
                while (c != '\uffff') {
                    if (c == '\t') {
                        n3 = n + ((Segment)object).getIndex() - ((Segment)object).getBeginIndex();
                        break;
                    }
                    c = ((Segment)object).next();
                }
            }
        }
        int n5 = this.text.toIteratorIndex(n3);
        if (this.measurer != null) {
            int n6 = this.text.toIteratorIndex(n);
            if (this.measurer.getPosition() != n6) {
                this.measurer.setPosition(n6);
            }
            n5 = this.measurer.nextOffset(n2, n5, bl);
        }
        int n7 = this.text.toModelPosition(n5);
        return n7;
    }

    void sync(FlowView flowView) {
        View view;
        FontRenderContext fontRenderContext;
        View view2 = this.getLogicalView(flowView);
        this.text.setView(view2);
        Graphics2D graphics2D = (Graphics2D)flowView.getContainer().getGraphics();
        try {
            if (graphics2D != null) {
                fontRenderContext = graphics2D.getFontRenderContext();
            } else {
                AffineTransform affineTransform = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
                fontRenderContext = new FontRenderContext(affineTransform, false, false);
            }
            view = null;
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (graphics2D != null) {
                graphics2D.dispose();
            }
            throw throwable;
        }
        this.measurer = new LineBreakMeasurer(this.text, fontRenderContext);
        int n = view2.getViewCount();
        int n2 = 0;
        while (n2 < n) {
            view = view2.getView(n2);
            if (view instanceof GlyphView) {
                int n3 = view.getStartOffset();
                int n4 = view.getEndOffset();
                this.measurer.setPosition(this.text.toIteratorIndex(n3));
                TextLayout textLayout = this.measurer.nextLayout(Float.MAX_VALUE, this.text.toIteratorIndex(n4), false);
                ((GlyphView)view).setGlyphPainter(new GlyphPainter2(textLayout));
            }
            ++n2;
        }
        this.measurer.setPosition(this.text.getBeginIndex());
    }

    static class AttributedSegment
    extends Segment
    implements AttributedCharacterIterator {
        View v;
        static Set keys = new HashSet();

        AttributedSegment() {
        }

        View getView() {
            return this.v;
        }

        void setView(View view) {
            this.v = view;
            Document document = view.getDocument();
            int n = view.getStartOffset();
            int n2 = view.getEndOffset();
            try {
                document.getText(n, n2 - n, this);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("Invalid view");
            }
            this.first();
        }

        int getFontBoundary(int n, int n2) {
            View view = this.v.getView(n);
            Font font = this.getFont(n);
            n += n2;
            while (n >= 0 && n < this.v.getViewCount()) {
                Font font2 = this.getFont(n);
                if (font2 != font) break;
                view = this.v.getView(n);
                n += n2;
            }
            return n2 < 0 ? view.getStartOffset() : view.getEndOffset();
        }

        Font getFont(int n) {
            View view = this.v.getView(n);
            if (view instanceof GlyphView) {
                return ((GlyphView)view).getFont();
            }
            return null;
        }

        int toModelPosition(int n) {
            return this.v.getStartOffset() + (n - this.getBeginIndex());
        }

        int toIteratorIndex(int n) {
            return n - this.v.getStartOffset() + this.getBeginIndex();
        }

        public int getRunStart() {
            int n = this.toModelPosition(this.getIndex());
            int n2 = this.v.getViewIndex(n, Position.Bias.Forward);
            View view = this.v.getView(n2);
            return this.toIteratorIndex(view.getStartOffset());
        }

        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (attribute instanceof TextAttribute) {
                int n = this.toModelPosition(this.getIndex());
                int n2 = this.v.getViewIndex(n, Position.Bias.Forward);
                if (attribute == TextAttribute.FONT) {
                    return this.toIteratorIndex(this.getFontBoundary(n2, -1));
                }
            }
            return this.getBeginIndex();
        }

        public int getRunStart(Set set) {
            int n = this.getBeginIndex();
            Object[] objectArray = set.toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                TextAttribute textAttribute = (TextAttribute)objectArray[n2];
                n = Math.max(this.getRunStart(textAttribute), n);
                ++n2;
            }
            return Math.min(this.getIndex(), n);
        }

        public int getRunLimit() {
            int n = this.toModelPosition(this.getIndex());
            int n2 = this.v.getViewIndex(n, Position.Bias.Forward);
            View view = this.v.getView(n2);
            return this.toIteratorIndex(view.getEndOffset());
        }

        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (attribute instanceof TextAttribute) {
                int n = this.toModelPosition(this.getIndex());
                int n2 = this.v.getViewIndex(n, Position.Bias.Forward);
                if (attribute == TextAttribute.FONT) {
                    return this.toIteratorIndex(this.getFontBoundary(n2, 1));
                }
            }
            return this.getEndIndex();
        }

        public int getRunLimit(Set set) {
            int n = this.getEndIndex();
            Object[] objectArray = set.toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                TextAttribute textAttribute = (TextAttribute)objectArray[n2];
                n = Math.min(this.getRunLimit(textAttribute), n);
                ++n2;
            }
            return Math.max(this.getIndex(), n);
        }

        public Map getAttributes() {
            Object[] objectArray = keys.toArray();
            Hashtable hashtable = new Hashtable();
            int n = 0;
            while (n < objectArray.length) {
                TextAttribute textAttribute = (TextAttribute)objectArray[n];
                Object object = this.getAttribute(textAttribute);
                if (object != null) {
                    hashtable.put(textAttribute, object);
                }
                ++n;
            }
            return hashtable;
        }

        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            int n = this.toModelPosition(this.getIndex());
            int n2 = this.v.getViewIndex(n, Position.Bias.Forward);
            if (attribute == TextAttribute.FONT) {
                return this.getFont(n2);
            }
            if (attribute == TextAttribute.RUN_DIRECTION) {
                return this.v.getDocument().getProperty(TextAttribute.RUN_DIRECTION);
            }
            return null;
        }

        public Set getAllAttributeKeys() {
            return keys;
        }

        static {
            keys.add(TextAttribute.FONT);
            keys.add(TextAttribute.RUN_DIRECTION);
        }
    }
}

