/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;

public class PixelToShapeConverter
implements PixelDrawPipe,
PixelFillPipe {
    ShapeDrawPipe outpipe;

    public PixelToShapeConverter(ShapeDrawPipe shapeDrawPipe) {
        this.outpipe = shapeDrawPipe;
    }

    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.outpipe.draw(sunGraphics2D, new Line2D.Float(n, n2, n3, n4));
    }

    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.outpipe.draw(sunGraphics2D, new Rectangle(n, n2, n3, n4));
    }

    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.outpipe.fill(sunGraphics2D, new Rectangle(n, n2, n3, n4));
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.outpipe.draw(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.outpipe.fill(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.outpipe.draw(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.outpipe.fill(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.outpipe.draw(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.outpipe.fill(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    private Shape makePoly(int[] nArray, int[] nArray2, int n, boolean bl) {
        GeneralPath generalPath = new GeneralPath(0);
        if (n > 0) {
            generalPath.moveTo(nArray[0], nArray2[0]);
        }
        int n2 = 1;
        while (n2 < n) {
            generalPath.lineTo(nArray[n2], nArray2[n2]);
            ++n2;
        }
        if (bl) {
            generalPath.closePath();
        }
        return generalPath;
    }

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.outpipe.draw(sunGraphics2D, this.makePoly(nArray, nArray2, n, false));
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.outpipe.draw(sunGraphics2D, this.makePoly(nArray, nArray2, n, true));
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.outpipe.fill(sunGraphics2D, this.makePoly(nArray, nArray2, n, true));
    }
}

