/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.util.Stack;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveEntry;

class ClientVector
extends Stack {
    private int num = 0;
    int nap;

    ClientVector(int n) {
        this.nap = n;
    }

    synchronized HttpClient get() {
        if (this.empty()) {
            return null;
        }
        HttpClient httpClient = null;
        long l = System.currentTimeMillis();
        do {
            KeepAliveEntry keepAliveEntry = (KeepAliveEntry)this.pop();
            if (l - keepAliveEntry.idleStartTime > (long)this.nap) {
                keepAliveEntry.hc.closeServer();
                continue;
            }
            httpClient = keepAliveEntry.hc;
        } while (httpClient == null && !this.empty());
        if (httpClient != null) {
            ++this.num;
        }
        return httpClient;
    }

    synchronized void put(HttpClient httpClient) {
        if (this.num + this.size() > KeepAliveCache.getMaxConnections()) {
            return;
        }
        if (this.num > 0) {
            --this.num;
        }
        this.push(new KeepAliveEntry(httpClient, System.currentTimeMillis()));
    }
}

