/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;

public final class SystemFlavorMap
implements FlavorMap {
    private static String JavaMIME = "JAVA_DATAFLAVOR:";
    private static final WeakHashMap flavorMaps = new WeakHashMap();
    private Properties nativeToMIME;
    private HashMap flavorToNative;
    private HashMap nativeToFlavor;

    public static FlavorMap getDefaultFlavorMap() {
        FlavorMap flavorMap;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        WeakHashMap weakHashMap = flavorMaps;
        synchronized (weakHashMap) {
            flavorMap = (FlavorMap)flavorMaps.get(classLoader);
            if (flavorMap == null) {
                flavorMap = new SystemFlavorMap();
                flavorMaps.put(classLoader, flavorMap);
            }
        }
        return flavorMap;
    }

    private SystemFlavorMap() {
        final Properties[] propertiesArray = new Properties[]{null};
        final boolean[] blArray = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = File.separator;
                String string2 = System.getProperty("java.home");
                String string3 = "file:" + string2 + string + "lib" + string + "flavormap.properties";
                try {
                    propertiesArray[0] = new Properties();
                    propertiesArray[0].load(new URL(string3).openStream());
                }
                catch (Exception exception) {
                    System.err.println("Exception:" + exception + " while loading default flavormap.properties file URL:" + string3);
                    propertiesArray[0] = null;
                }
                SystemFlavorMap.this.nativeToMIME = new Properties(propertiesArray[0]);
                Toolkit.getDefaultToolkit();
                String string4 = Toolkit.getProperty("AWT.DnD.flavorMapFileURL", null);
                InputStream inputStream = null;
                if (string4 != null) {
                    try {
                        inputStream = new URL(string4).openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println(this.getClass().getName() + ": Malformed URL for flavormap: " + string4);
                    }
                    catch (IOException iOException) {
                        System.err.println(this.getClass().getName() + ": IOException during open of flavormap: " + string4);
                    }
                }
                if (inputStream != null) {
                    try {
                        SystemFlavorMap.this.nativeToMIME.load(inputStream);
                    }
                    catch (IOException iOException) {
                        System.err.println(this.getClass().getName() + "IOException during load of flavormap: " + string4);
                        blArray[0] = true;
                        return null;
                    }
                }
                return null;
            }
        });
        if (blArray[0]) {
            return;
        }
        int n = this.nativeToMIME.size() + (propertiesArray[0] != null ? propertiesArray[0].size() : 0);
        int n2 = n > 0 ? n : 1;
        this.flavorToNative = new HashMap(n2);
        this.nativeToFlavor = new HashMap(n2);
        if (n > 0) {
            Enumeration enumeration = this.nativeToMIME.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.nativeToMIME.getProperty(string);
                DataFlavor dataFlavor = null;
                try {
                    dataFlavor = new DataFlavor(string2);
                }
                catch (Exception exception) {
                    try {
                        dataFlavor = new DataFlavor(string2, (String)null);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                        continue;
                    }
                }
                this.flavorToNative.put(dataFlavor.getMimeType(), string);
                this.nativeToFlavor.put(string, dataFlavor);
            }
        }
    }

    public synchronized Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
        if (dataFlavorArray == null) {
            return (Map)this.flavorToNative.clone();
        }
        if (dataFlavorArray.length == 0) {
            return null;
        }
        HashMap hashMap = new HashMap(dataFlavorArray.length);
        int n = 0;
        while (n < dataFlavorArray.length) {
            DataFlavor dataFlavor = dataFlavorArray[n];
            String string = dataFlavor.getMimeType();
            String string2 = (String)this.flavorToNative.get(string);
            if (string2 == null) {
                String string3 = SystemFlavorMap.encodeJavaMIMEType(string);
                hashMap.put(dataFlavor, string3);
                this.nativeToFlavor.put(string3, dataFlavor);
                this.flavorToNative.put(string, string3);
            } else {
                hashMap.put(dataFlavor, string2);
            }
            ++n;
        }
        return hashMap;
    }

    public synchronized Map getFlavorsForNatives(String[] stringArray) {
        boolean bl = false;
        if (stringArray == null) {
            return (Map)this.nativeToFlavor.clone();
        }
        if (stringArray.length == 0) {
            return new HashMap();
        }
        HashMap hashMap = new HashMap(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            DataFlavor dataFlavor = null;
            if (SystemFlavorMap.isJavaMIMEType(stringArray[n])) {
                String string2 = stringArray[n];
                dataFlavor = (DataFlavor)this.nativeToFlavor.get(string2);
                if (dataFlavor == null) {
                    String string3 = SystemFlavorMap.decodeJavaMIMEType(stringArray[n]);
                    try {
                        dataFlavor = new DataFlavor(string3);
                    }
                    catch (Exception exception) {
                        System.err.println("Exception \"" + exception.getClass().getName() + ": " + exception.getMessage() + "\"while constructing DataFlavor for: " + string3);
                        dataFlavor = null;
                    }
                    if (dataFlavor != null) {
                        this.nativeToFlavor.put(string2, dataFlavor);
                        this.flavorToNative.put(dataFlavor.getMimeType(), string2);
                    }
                }
            } else {
                dataFlavor = (DataFlavor)this.nativeToFlavor.get(string);
            }
            if (dataFlavor != null) {
                hashMap.put(string, dataFlavor);
            }
            ++n;
        }
        return hashMap;
    }

    public static String encodeJavaMIMEType(String string) {
        return JavaMIME + string;
    }

    public static String encodeDataFlavor(DataFlavor dataFlavor) {
        return JavaMIME + dataFlavor.getMimeType();
    }

    public static boolean isJavaMIMEType(String string) {
        return string != null && string.startsWith(JavaMIME, 0);
    }

    public static String decodeJavaMIMEType(String string) {
        if (!SystemFlavorMap.isJavaMIMEType(string)) {
            return null;
        }
        return string.substring(JavaMIME.length(), string.length()).trim();
    }

    public static DataFlavor decodeDataFlavor(String string) throws ClassNotFoundException {
        if (!SystemFlavorMap.isJavaMIMEType(string)) {
            return null;
        }
        return new DataFlavor(string.substring(JavaMIME.length(), string.length()).trim());
    }
}

