/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private String str;
    private int length;
    private int next = 0;
    private int mark = 0;

    public StringReader(String string) {
        this.str = string;
        this.length = string.length();
    }

    private void ensureOpen() throws IOException {
        if (this.str == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                int n = -1;
                return n;
            }
            char c = this.str.charAt(this.next++);
            return c;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                int n3 = 0;
                return n3;
            }
            if (this.next >= this.length) {
                int n4 = -1;
                return n4;
            }
            int n5 = Math.min(this.length - this.next, n2);
            this.str.getChars(this.next, this.next + n5, cArray, n);
            this.next += n5;
            int n6 = n5;
            return n6;
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                long l2 = 0L;
                return l2;
            }
            long l3 = Math.min((long)(this.length - this.next), l);
            this.next = (int)((long)this.next + l3);
            long l4 = l3;
            return l4;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            boolean bl = true;
            return bl;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mark = this.next;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.next = this.mark;
        }
    }

    public void close() {
        this.str = null;
    }
}

