/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicProgressBarUI
extends ProgressBarUI {
    private static final Dimension PREFERRED_INNER_HORIZONTAL = new Dimension(146, 12);
    private static final Dimension PREFERRED_INNER_VERTICAL = new Dimension(12, 146);
    private int cachedPercent;
    private int cellLength;
    private int cellSpacing;
    private Color selectionForeground;
    private Color selectionBackground;
    protected JProgressBar progressBar;
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicProgressBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.progressBar = (JProgressBar)jComponent;
        this.installDefaults();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.progressBar = null;
    }

    protected void installDefaults() {
        this.progressBar.setOpaque(true);
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.cellLength = UIManager.getInt("ProgressBar.cellLength");
        this.cellSpacing = UIManager.getInt("ProgressBar.cellSpacing");
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
        this.selectionBackground = UIManager.getColor("ProgressBar.selectionBackground");
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.progressBar);
    }

    protected void installListeners() {
        this.changeListener = new ChangeHandler();
        this.progressBar.addChangeListener(this.changeListener);
    }

    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.changeListener);
    }

    protected Dimension getPreferredInnerHorizontal() {
        return PREFERRED_INNER_HORIZONTAL;
    }

    protected Dimension getPreferredInnerVertical() {
        return PREFERRED_INNER_VERTICAL;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    private int getCachedPercent() {
        return this.cachedPercent;
    }

    private void setCachedPercent(int n) {
        this.cachedPercent = n;
    }

    protected int getCellLength() {
        if (this.progressBar.isStringPainted()) {
            return 1;
        }
        return this.cellLength;
    }

    protected void setCellLength(int n) {
        this.cellLength = n;
    }

    protected int getCellSpacing() {
        if (this.progressBar.isStringPainted()) {
            return 0;
        }
        return this.cellSpacing;
    }

    protected void setCellSpacing(int n) {
        this.cellSpacing = n;
    }

    protected int getAmountFull(Insets insets, int n, int n2) {
        int n3 = 0;
        BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        if (boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum() != 0) {
            n3 = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)n * this.progressBar.getPercentComplete()) : (int)Math.round((double)n2 * this.progressBar.getPercentComplete());
        }
        return n3;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        int n = 0;
        int n2 = 0;
        int n3 = this.progressBar.getWidth();
        int n4 = this.progressBar.getHeight();
        Insets insets = this.progressBar.getInsets();
        int n5 = this.getCellLength();
        int n6 = this.getCellSpacing();
        int n7 = n5 + n6;
        int n8 = this.getAmountFull(insets, n3 -= insets.right + (n += insets.left), n4 -= insets.bottom + (n2 += insets.top));
        graphics.setColor(this.progressBar.getForeground());
        if (this.progressBar.getOrientation() == 0) {
            int n9 = n;
            boolean bl = BasicGraphicsUtils.isLeftToRight(jComponent);
            if (!bl) {
                n9 += n3 - n8;
            }
            if (n6 == 0 && n8 > 0) {
                graphics.fillRect(n9, n2, n8, n4);
            } else {
                Rectangle rectangle = graphics.getClipBounds();
                graphics.setClip(n, n2, n3, n4);
                int n10 = (int)Math.ceil((double)n8 / (double)n7);
                if (!bl) {
                    n9 += n6 - (n10 * n7 - n8);
                }
                int n11 = n9;
                while (n10-- > 0) {
                    graphics.fillRect(n11, n2, n5, n4);
                    n11 += n7;
                }
                graphics.setClip(rectangle);
            }
        } else {
            int n12 = n2 + n4 - n8;
            if (n6 == 0 && n8 > 0) {
                graphics.fillRect(n, n12, n3, n8);
            } else {
                Rectangle rectangle = graphics.getClipBounds();
                graphics.setClip(n, n2, n3, n4);
                int n13 = (int)Math.ceil((double)n8 / (double)n7);
                int n14 = n12 += n6 - (n13 * n7 - n8);
                while (n13-- > 0) {
                    graphics.fillRect(n, n14, n3, n5);
                    n14 += n7;
                }
                graphics.setClip(rectangle);
            }
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(graphics, n, n2, n3, n4, n8, insets);
        }
    }

    protected void paintString(Graphics graphics, int n, int n2, int n3, int n4, int n5, Insets insets) {
        String string = this.progressBar.getString();
        graphics.setFont(this.progressBar.getFont());
        Point point = this.getStringPlacement(graphics, string, n, n2, n3, n4);
        Rectangle rectangle = graphics.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            graphics.setColor(this.getSelectionForeground());
            graphics.drawString(string, point.x, point.y);
            graphics.setColor(this.getSelectionBackground());
            if (BasicGraphicsUtils.isLeftToRight(this.progressBar)) {
                graphics.setClip(n + n5, n2, n3 - n5, n4);
            } else {
                graphics.setClip(n, n2, n3 - n5, n4);
            }
            graphics.drawString(string, point.x, point.y);
        } else {
            graphics.setColor(this.getSelectionBackground());
            graphics.drawString(string, point.x, point.y);
            graphics.setColor(this.getSelectionForeground());
            graphics.setClip(n, n4 - n5 + insets.top, n3, n4);
            graphics.drawString(string, point.x, point.y);
        }
        graphics.setClip(rectangle);
    }

    protected Point getStringPlacement(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getAscent() + fontMetrics.getDescent();
        if (this.progressBar.getOrientation() == 0) {
            return new Point(n + Math.round(n3 / 2 - n5 / 2), n2 + fontMetrics.getHeight() - Math.round(fontMetrics.getDescent() / 2));
        }
        return new Point(n + Math.round(n3 / 2 - n5 / 2), n2 + Math.round(n4 / 2 + n6 / 2));
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        Insets insets = this.progressBar.getInsets();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        if (this.progressBar.getOrientation() == 0) {
            dimension = new Dimension(this.getPreferredInnerHorizontal());
            if (this.progressBar.isStringPainted()) {
                int n;
                String string = this.progressBar.getString();
                int n2 = fontMetrics.stringWidth(string);
                if (n2 > dimension.width) {
                    dimension.width = n2;
                }
                if ((n = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
                    dimension.height = n;
                }
            }
        } else {
            dimension = new Dimension(this.getPreferredInnerVertical());
            if (this.progressBar.isStringPainted()) {
                int n;
                String string = new String("100%");
                int n3 = fontMetrics.stringWidth(string);
                if (n3 > dimension.width) {
                    dimension.width = n3;
                }
                if ((n3 = fontMetrics.stringWidth(string = this.progressBar.getString())) > dimension.width) {
                    dimension.width = n3;
                }
                if ((n = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
                    dimension.height = n;
                }
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = 10;
        } else {
            dimension.height = 10;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            BoundedRangeModel boundedRangeModel = BasicProgressBarUI.this.progressBar.getModel();
            int n2 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            int n3 = n2 > 0 ? 100 * boundedRangeModel.getValue() / n2 : 0;
            if (n3 != (n = BasicProgressBarUI.this.getCachedPercent())) {
                BasicProgressBarUI.this.setCachedPercent(n3);
                BasicProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

