/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.CFFFont;
import com.lowagie.text.pdf.CFFFontSubset;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.TrueTypeFontSubSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

class TrueTypeFontUnicode
extends TrueTypeFont
implements Comparator {
    boolean vertical = false;

    TrueTypeFontUnicode(String string, String string2, boolean bl, byte[] byArray) throws DocumentException, IOException {
        String string3 = TrueTypeFontUnicode.getBaseName(string);
        String string4 = TrueTypeFontUnicode.getTTCName(string3);
        if (string3.length() < string.length()) {
            this.style = string.substring(string3.length());
        }
        this.encoding = string2;
        this.embedded = bl;
        this.fileName = string4;
        this.ttcIndex = "";
        if (string4.length() < string3.length()) {
            this.ttcIndex = string3.substring(string4.length() + 1);
        }
        this.fontType = 3;
        if ((this.fileName.toLowerCase().endsWith(".ttf") || this.fileName.toLowerCase().endsWith(".otf") || this.fileName.toLowerCase().endsWith(".ttc")) && (string2.equals("Identity-H") || string2.equals("Identity-V")) && bl) {
            this.process(byArray);
            if (this.os_2.fsType == 2) {
                throw new DocumentException(this.fileName + this.style + " cannot be embedded due to licensing restrictions.");
            }
            if (this.cmap31 == null && !this.fontSpecific || this.cmap10 == null && this.fontSpecific) {
                this.directTextToByte = true;
            }
            if (this.fontSpecific) {
                this.fontSpecific = false;
                String string5 = this.encoding;
                this.encoding = "";
                this.createEncoding();
                this.encoding = string5;
                this.fontSpecific = true;
            }
        } else {
            throw new DocumentException(this.fileName + " " + this.style + " is not a TTF font file.");
        }
        this.vertical = string2.endsWith("V");
    }

    public int getWidth(String string) {
        if (this.vertical) {
            return string.length() * 1000;
        }
        int n = 0;
        if (this.fontSpecific) {
            char[] cArray = string.toCharArray();
            boolean bl = false;
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                char c = cArray[i];
                if ((c & 0xFF00) != 0 && (c & 0xFF00) != 61440) continue;
                n += this.getRawWidth(c & 0xFF, null);
            }
        } else {
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                n += this.getRawWidth(string.charAt(i), this.encoding);
            }
        }
        return n;
    }

    private PdfStream getToUnicode(Object[] objectArray) throws DocumentException {
        Object object;
        if (objectArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n" + TrueTypeFontUnicode.toHex(((int[])objectArray[0])[0]) + TrueTypeFontUnicode.toHex(((int[])objectArray[objectArray.length - 1])[0]) + "\n" + "endcodespacerange\n");
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (n == 0) {
                if (i != 0) {
                    stringBuffer.append("endbfrange\n");
                }
                n = Math.min(100, objectArray.length - i);
                stringBuffer.append(n).append(" beginbfrange\n");
            }
            --n;
            object = (int[])objectArray[i];
            String string = TrueTypeFontUnicode.toHex(object[0]);
            stringBuffer.append(string).append(string).append(TrueTypeFontUnicode.toHex((int)object[2])).append("\n");
        }
        stringBuffer.append("endbfrange\nendcmap\nCMapName currentdict /CMap defineresource pop\nend end\n");
        String string = stringBuffer.toString();
        object = new PdfStream(PdfEncodings.convertToBytes(string, null));
        ((PdfStream)object).flateCompress();
        return object;
    }

    static String toHex(int n) {
        String string = Integer.toHexString(n);
        return "<0000".substring(0, 5 - string.length()) + string + ">";
    }

    private PdfDictionary getCIDFontType2(PdfIndirectReference pdfIndirectReference, String string, Object[] objectArray) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        if (this.cff) {
            pdfDictionary.put(PdfName.SUBTYPE, PdfName.CIDFONTTYPE0);
            pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName + "-" + this.encoding));
        } else {
            pdfDictionary.put(PdfName.SUBTYPE, PdfName.CIDFONTTYPE2);
            pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName));
        }
        pdfDictionary.put(PdfName.FONTDESCRIPTOR, pdfIndirectReference);
        if (!this.cff) {
            pdfDictionary.put(PdfName.CIDTOGIDMAP, PdfName.IDENTITY);
        }
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.REGISTRY, new PdfString("Adobe"));
        pdfDictionary2.put(PdfName.ORDERING, new PdfString("Identity"));
        pdfDictionary2.put(PdfName.SUPPLEMENT, new PdfNumber(0));
        pdfDictionary.put(PdfName.CIDSYSTEMINFO, pdfDictionary2);
        if (!this.vertical) {
            pdfDictionary.put(PdfName.DW, new PdfNumber(1000));
            StringBuffer stringBuffer = new StringBuffer("[");
            int n = -10;
            boolean bl = true;
            for (int i = 0; i < objectArray.length; ++i) {
                int[] nArray = (int[])objectArray[i];
                if (nArray[1] == 1000) continue;
                int n2 = nArray[0];
                if (n2 == n + 1) {
                    stringBuffer.append(" ").append(nArray[1]);
                } else {
                    if (!bl) {
                        stringBuffer.append("]");
                    }
                    bl = false;
                    stringBuffer.append(n2).append("[").append(nArray[1]);
                }
                n = n2;
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append("]]");
                pdfDictionary.put(PdfName.W, new PdfLiteral(stringBuffer.toString()));
            }
        }
        return pdfDictionary;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference, String string, PdfIndirectReference pdfIndirectReference2) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, PdfName.TYPE0);
        if (this.cff) {
            pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName + "-" + this.encoding));
        } else {
            pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName));
        }
        pdfDictionary.put(PdfName.ENCODING, new PdfName(this.encoding));
        pdfDictionary.put(PdfName.DESCENDANTFONTS, new PdfArray(pdfIndirectReference));
        if (pdfIndirectReference2 != null) {
            pdfDictionary.put(PdfName.TOUNICODE, pdfIndirectReference2);
        }
        return pdfDictionary;
    }

    public int compare(Object object, Object object2) {
        int n = ((int[])object)[0];
        int n2 = ((int[])object2)[0];
        if (n < n2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        Object object;
        Object object2;
        Object object3;
        HashMap hashMap = (HashMap)objectArray[0];
        Object[] objectArray2 = hashMap.values().toArray();
        Arrays.sort(objectArray2, this);
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfDictionary pdfDictionary = null;
        PdfIndirectObject pdfIndirectObject = null;
        if (this.cff) {
            object3 = new RandomAccessFileOrArray(this.rf);
            object2 = new byte[this.cffLength];
            try {
                ((RandomAccessFileOrArray)object3).reOpen();
                ((RandomAccessFileOrArray)object3).seek(this.cffOffset);
                ((RandomAccessFileOrArray)object3).readFully((byte[])object2);
            }
            finally {
                try {
                    ((RandomAccessFileOrArray)object3).close();
                }
                catch (Exception exception) {}
            }
            object = new CFFFontSubset(new RandomAccessFileOrArray((byte[])object2), hashMap);
            object2 = ((CFFFontSubset)object).Process(((CFFFont)object).getNames()[0]);
            pdfDictionary = new BaseFont.StreamFont((byte[])object2, "CIDFontType0C");
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        } else {
            object3 = new TrueTypeFontSubSet(this.fileName, new RandomAccessFileOrArray(this.rf), hashMap, this.directoryOffset, false);
            object2 = ((TrueTypeFontSubSet)object3).process();
            object = new int[]{((byte[])object2).length};
            pdfDictionary = new BaseFont.StreamFont((byte[])object2, (int[])object);
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        object3 = TrueTypeFontUnicode.createSubsetPrefix();
        object2 = this.getFontDescriptor(pdfIndirectReference2, (String)object3);
        pdfIndirectObject = pdfWriter.addToBody((PdfObject)object2);
        pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        pdfDictionary = this.getCIDFontType2(pdfIndirectReference2, (String)object3, objectArray2);
        pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
        pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        pdfDictionary = this.getToUnicode(objectArray2);
        object = null;
        if (pdfDictionary != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            object = pdfIndirectObject.getIndirectReference();
        }
        pdfDictionary = this.getFontBaseType(pdfIndirectReference2, (String)object3, (PdfIndirectReference)object);
        pdfWriter.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
    }

    byte[] convertToBytes(String string) {
        return null;
    }

    public boolean charExists(char c) {
        HashMap hashMap = null;
        hashMap = this.fontSpecific ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return false;
        }
        if (this.fontSpecific) {
            if ((c & 0xFF00) == 0 || (c & 0xFF00) == 61440) {
                return hashMap.get(new Integer(c & 0xFF)) != null;
            }
            return false;
        }
        return hashMap.get(new Integer(c)) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setCharAdvance(char c, int n) {
        HashMap hashMap = null;
        hashMap = this.fontSpecific ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return false;
        }
        int[] nArray = null;
        if (this.fontSpecific) {
            if ((c & 0xFF00) != 0 && (c & 0xFF00) != 61440) return false;
            nArray = (int[])hashMap.get(new Integer(c & 0xFF));
        } else {
            nArray = (int[])hashMap.get(new Integer(c));
        }
        if (nArray == null) {
            return false;
        }
        nArray[1] = n;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getCharBBox(char c) {
        if (this.bboxes == null) {
            return null;
        }
        HashMap hashMap = null;
        hashMap = this.fontSpecific ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return null;
        }
        int[] nArray = null;
        if (this.fontSpecific) {
            if ((c & 0xFF00) != 0 && (c & 0xFF00) != 61440) return null;
            nArray = (int[])hashMap.get(new Integer(c & 0xFF));
        } else {
            nArray = (int[])hashMap.get(new Integer(c));
        }
        if (nArray != null) return this.bboxes[nArray[0]];
        return null;
    }
}

