/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.StringTokenizer;
import java.util.jar.Attributes;

public class ExtensionInfo {
    public static final int COMPATIBLE = 0;
    public static final int REQUIRE_SPECIFICATION_UPGRADE = 1;
    public static final int REQUIRE_IMPLEMENTATION_UPGRADE = 2;
    public static final int REQUIRE_VENDOR_SWITCH = 3;
    public static final int INCOMPATIBLE = 4;
    public String title;
    public String name;
    public String specVersion;
    public String specVendor;
    public String implementationVersion;
    public String vendor;
    public String vendorId;
    public String url;

    public ExtensionInfo() {
    }

    public ExtensionInfo(String string, Attributes attributes) throws NullPointerException {
        String string2 = string != null ? string + "-" : "";
        String string3 = string2 + Attributes.Name.EXTENSION_NAME.toString();
        this.name = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.SPECIFICATION_TITLE.toString();
        this.title = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.SPECIFICATION_VERSION.toString();
        this.specVersion = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.SPECIFICATION_VERSION.toString();
        this.specVersion = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.IMPLEMENTATION_VERSION.toString();
        this.implementationVersion = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.IMPLEMENTATION_VENDOR.toString();
        this.vendor = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString();
        this.vendorId = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.IMPLEMENTATION_URL.toString();
        this.url = attributes.getValue(string3);
    }

    public int isCompatibleWith(ExtensionInfo extensionInfo) {
        if (this.name == null || extensionInfo.name == null) {
            return 4;
        }
        if (this.name.compareTo(extensionInfo.name) == 0) {
            System.out.println("Potential match");
            if (this.specVersion == null || extensionInfo.specVersion == null) {
                return 0;
            }
            int n = this.compareExtensionVersion(this.specVersion, extensionInfo.specVersion);
            if (n < 0) {
                if (this.vendorId != null && extensionInfo.vendorId != null && this.vendorId.compareTo(extensionInfo.vendorId) != 0) {
                    return 3;
                }
                return 1;
            }
            if (this.vendorId != null && extensionInfo.vendorId != null) {
                if (this.vendorId.compareTo(extensionInfo.vendorId) != 0) {
                    return 3;
                }
                if (this.implementationVersion != null && extensionInfo.implementationVersion != null && (n = this.compareExtensionVersion(this.implementationVersion, extensionInfo.implementationVersion)) < 0) {
                    return 2;
                }
            }
            return 0;
        }
        return 4;
    }

    public String toString() {
        return "Extension : " + this.title + "(" + this.name + "), spec version(" + this.specVersion + "), impl version(" + this.implementationVersion + ") from " + this.vendor + "(" + this.vendorId + ")";
    }

    private int compareExtensionVersion(String string, String string2) throws NumberFormatException {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        return this.strictCompareExtensionVersion(string, string2);
    }

    private int strictCompareExtensionVersion(String string, String string2) throws NumberFormatException {
        if (string.equals(string2)) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".,");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".,");
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (stringTokenizer.hasMoreTokens()) {
            n = this.convertToken(stringTokenizer.nextToken().toString());
        }
        if (stringTokenizer2.hasMoreTokens()) {
            n2 = this.convertToken(stringTokenizer2.nextToken().toString());
        }
        if (n > n2) {
            return 1;
        }
        if (n2 > n) {
            return -1;
        }
        int n3 = string.indexOf(".");
        int n4 = string2.indexOf(".");
        if (n3 == -1) {
            n3 = string.length() - 1;
        }
        if (n4 == -1) {
            n4 = string2.length() - 1;
        }
        return this.strictCompareExtensionVersion(string.substring(n3 + 1), string2.substring(n4 + 1));
    }

    private int convertToken(String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        int n = string.indexOf("-");
        int n2 = string.indexOf("_");
        if (n == -1 && n2 == -1) {
            return Integer.parseInt(string) * 100;
        }
        if (n2 != -1) {
            int n3 = Integer.parseInt(string.substring(0, n2));
            int n4 = Integer.parseInt(string.substring(n2 + 1));
            return n3 * 100 + n4;
        }
        int n5 = Integer.parseInt(string.substring(0, n));
        String string2 = string.substring(n + 1);
        String string3 = "";
        int n6 = 0;
        if (string2.indexOf("ea") != -1) {
            string3 = string2.substring(2);
            n6 = 50;
        } else if (string2.indexOf("alpha") != -1) {
            string3 = string2.substring(5);
            n6 = 40;
        } else if (string2.indexOf("beta") != -1) {
            string3 = string2.substring(4);
            n6 = 30;
        } else if (string2.indexOf("rc") != -1) {
            string3 = string2.substring(2);
            n6 = 20;
        }
        if (string3 == null || string3.equals("")) {
            return n5 * 100 - n6;
        }
        return n5 * 100 - n6 + Integer.parseInt(string3);
    }
}

