/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

class ArcIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    double angStRad;
    double angExtDeg;
    AffineTransform affine;
    int index;
    int arcSegs;
    int lineSegs;

    ArcIterator(Arc2D arc2D, AffineTransform affineTransform) {
        this.w = arc2D.getWidth() / 2.0;
        this.h = arc2D.getHeight() / 2.0;
        this.x = arc2D.getX() + this.w;
        this.y = arc2D.getY() + this.h;
        this.angStRad = -Math.toRadians(arc2D.getAngleStart());
        this.angExtDeg = -arc2D.getAngleExtent();
        this.affine = affineTransform;
        double d = Math.abs(this.angExtDeg);
        this.arcSegs = d >= 360.0 ? 4 : (int)Math.ceil(d / 90.0);
        switch (arc2D.getArcType()) {
            case 0: {
                this.lineSegs = 0;
                break;
            }
            case 1: {
                this.lineSegs = 1;
                break;
            }
            case 2: {
                this.lineSegs = 2;
            }
        }
        if (this.w < 0.0 || this.h < 0.0) {
            this.lineSegs = -1;
            this.arcSegs = -1;
        }
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.index > this.arcSegs + this.lineSegs;
    }

    public void next() {
        ++this.index;
    }

    private static double btan(double d) {
        return 1.3333333333333333 * Math.sin(d /= 2.0) / (1.0 + Math.cos(d));
    }

    public int currentSegment(float[] fArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("arc iterator out of bounds");
        }
        double d = this.angStRad;
        if (this.index == 0) {
            fArray[0] = (float)(this.x + Math.cos(d) * this.w);
            fArray[1] = (float)(this.y + Math.sin(d) * this.h);
            if (this.affine != null) {
                this.affine.transform(fArray, 0, fArray, 0, 1);
            }
            return 0;
        }
        if (this.index > this.arcSegs) {
            if (this.index == this.arcSegs + this.lineSegs) {
                return 4;
            }
            fArray[0] = (float)this.x;
            fArray[1] = (float)this.y;
            if (this.affine != null) {
                this.affine.transform(fArray, 0, fArray, 0, 1);
            }
            return 1;
        }
        double d2 = this.angExtDeg;
        if (d2 > 360.0) {
            d2 = 360.0;
        } else if (d2 < -360.0) {
            d2 = -360.0;
        }
        d2 /= (double)this.arcSegs;
        d2 = Math.toRadians(d2);
        double d3 = Math.cos(d += d2 * (double)(this.index - 1));
        double d4 = Math.sin(d);
        double d5 = ArcIterator.btan(d2);
        fArray[0] = (float)(this.x + (d3 - d5 * d4) * this.w);
        fArray[1] = (float)(this.y + (d4 + d5 * d3) * this.h);
        d3 = Math.cos(d += d2);
        d4 = Math.sin(d);
        fArray[2] = (float)(this.x + (d3 + d5 * d4) * this.w);
        fArray[3] = (float)(this.y + (d4 - d5 * d3) * this.h);
        fArray[4] = (float)(this.x + d3 * this.w);
        fArray[5] = (float)(this.y + d4 * this.h);
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, 3);
        }
        return 3;
    }

    public int currentSegment(double[] dArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("arc iterator out of bounds");
        }
        double d = this.angStRad;
        if (this.index == 0) {
            dArray[0] = this.x + Math.cos(d) * this.w;
            dArray[1] = this.y + Math.sin(d) * this.h;
            if (this.affine != null) {
                this.affine.transform(dArray, 0, dArray, 0, 1);
            }
            return 0;
        }
        if (this.index > this.arcSegs) {
            if (this.index == this.arcSegs + this.lineSegs) {
                return 4;
            }
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.affine != null) {
                this.affine.transform(dArray, 0, dArray, 0, 1);
            }
            return 1;
        }
        double d2 = this.angExtDeg;
        if (d2 > 360.0) {
            d2 = 360.0;
        } else if (d2 < -360.0) {
            d2 = -360.0;
        }
        d2 /= (double)this.arcSegs;
        d2 = Math.toRadians(d2);
        double d3 = Math.cos(d += d2 * (double)(this.index - 1));
        double d4 = Math.sin(d);
        double d5 = ArcIterator.btan(d2);
        dArray[0] = this.x + (d3 - d5 * d4) * this.w;
        dArray[1] = this.y + (d4 + d5 * d3) * this.h;
        d3 = Math.cos(d += d2);
        d4 = Math.sin(d);
        dArray[2] = this.x + (d3 + d5 * d4) * this.w;
        dArray[3] = this.y + (d4 - d5 * d3) * this.h;
        dArray[4] = this.x + d3 * this.w;
        dArray[5] = this.y + d4 * this.h;
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, 3);
        }
        return 3;
    }
}

