/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuUI";
    private JPopupMenu popupMenu;
    private ChangeListener menuChangeListener = null;
    private MenuEvent menuEvent = null;
    private static Hashtable listenerRegistry = null;
    private int delay;
    private boolean receivedKeyPressed;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    protected WinListener popupListener;
    static /* synthetic */ Class class$javax$swing$event$MenuListener;

    public JMenu() {
        this("");
    }

    public JMenu(String string) {
        super(string);
    }

    public JMenu(Action action) {
        this();
        this.setAction(action);
    }

    public JMenu(String string, boolean bl) {
        this(string);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        super.setModel(buttonModel);
        if (buttonModel2 != null && this.menuChangeListener != null) {
            buttonModel2.removeChangeListener(this.menuChangeListener);
            this.menuChangeListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.menuChangeListener = this.createMenuChangeListener();
            buttonModel.addChangeListener(this.menuChangeListener);
        }
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public void setSelected(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = buttonModel.isSelected();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        if (bl != buttonModel.isSelected()) {
            this.getModel().setSelected(bl);
        }
    }

    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    public void setPopupMenuVisible(boolean bl) {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl2 = this.isPopupMenuVisible();
        if (bl != bl2) {
            this.ensurePopupMenuCreated();
            if (bl && this.isShowing()) {
                Point point = this.getPopupMenuOrigin();
                this.getPopupMenu().show(this, point.x, point.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    protected Point getPopupMenuOrigin() {
        Object object;
        Object object2;
        int n = 0;
        int n2 = 0;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n3 = 0;
        while (n3 < graphicsDeviceArray.length) {
            object2 = graphicsDeviceArray[n3];
            if (((GraphicsDevice)object2).getType() == 0 && (rectangle = rectangle.union(((GraphicsConfiguration)(object = ((GraphicsDevice)object2).getDefaultConfiguration())).getBounds())).contains(this.getLocationOnScreen())) break;
            ++n3;
        }
        object2 = this.getSize();
        object = jPopupMenu.getSize();
        if (((Dimension)object).width == 0) {
            object = jPopupMenu.getPreferredSize();
        }
        Point point = this.getLocationOnScreen();
        Container container = this.getParent();
        if (container instanceof JPopupMenu) {
            n = SwingUtilities.isLeftToRight(this) ? (point.x + ((Dimension)object2).width + ((Dimension)object).width < rectangle.width ? ((Dimension)object2).width : 0 - ((Dimension)object).width) : (point.x < ((Dimension)object).width ? ((Dimension)object2).width : 0 - ((Dimension)object).width);
            n2 = point.y + ((Dimension)object).height < rectangle.height ? 0 : ((Dimension)object2).height - ((Dimension)object).height;
        } else {
            n = SwingUtilities.isLeftToRight(this) ? (point.x + ((Dimension)object).width < rectangle.width ? 0 : ((Dimension)object2).width - ((Dimension)object).width) : (point.x + ((Dimension)object2).width < ((Dimension)object).width ? 0 : ((Dimension)object2).width - ((Dimension)object).width);
            n2 = point.y + ((Dimension)object2).height + ((Dimension)object).height < rectangle.height ? ((Dimension)object2).height : 0 - ((Dimension)object).height;
        }
        return new Point(n, n2);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Delay must be a positive integer");
        }
        this.delay = n;
    }

    private void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            JMenu jMenu = this;
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
            this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    JMenu.this.fireMenuCanceled();
                }
            });
        }
    }

    public void setMenuLocation(int n, int n2) {
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(n, n2);
        }
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(jMenuItem);
    }

    public Component add(Component component) {
        AccessibleContext accessibleContext;
        if (component instanceof JComponent && (accessibleContext = ((JComponent)component).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component);
        return component;
    }

    public Component add(Component component, int n) {
        AccessibleContext accessibleContext;
        if (component instanceof JComponent && (accessibleContext = ((JComponent)component).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component, n);
        return component;
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add(jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem createActionComponent(Action action) {
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon")){

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = JMenu.this.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        return jMenuItem;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    public void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(string), n);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        jMenuItem.setAction(action);
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JPopupMenu.Separator(), n);
    }

    public JMenuItem getItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        Component component = this.getMenuComponent(n);
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            return jMenuItem;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        throw new Error("boolean isTearOff() {} not yet implemented");
    }

    public void remove(JMenuItem jMenuItem) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(jMenuItem);
        }
    }

    public void remove(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(n);
        }
    }

    public void remove(Component component) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(component);
        }
    }

    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    public int getMenuComponentCount() {
        int n = 0;
        if (this.popupMenu != null) {
            n = this.popupMenu.getComponentCount();
        }
        return n;
    }

    public Component getMenuComponent(int n) {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponent(n);
        }
        return null;
    }

    public Component[] getMenuComponents() {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponents();
        }
        return new Component[0];
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        JPopupMenu jPopupMenu;
        if (component == this) {
            return true;
        }
        if (component instanceof JPopupMenu && (jPopupMenu = (JPopupMenu)component) == this.getPopupMenu()) {
            return true;
        }
        int n = this.getMenuComponentCount();
        Component[] componentArray = this.getMenuComponents();
        int n2 = 0;
        while (n2 < n) {
            JMenu jMenu;
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return true;
            }
            if (component2 instanceof JMenu && (jMenu = (JMenu)component2).isMenuComponent(component)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Point translateToPopupMenu(Point point) {
        return this.translateToPopupMenu(point.x, point.y);
    }

    private Point translateToPopupMenu(int n, int n2) {
        int n3;
        int n4;
        if (this.getParent() instanceof JPopupMenu) {
            n4 = n - this.getSize().width;
            n3 = n2;
        } else {
            n4 = n;
            n3 = n2 - this.getSize().height;
        }
        return new Point(n4, n3);
    }

    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener menuListener) {
        this.listenerList.add(class$javax$swing$event$MenuListener == null ? (class$javax$swing$event$MenuListener = JMenu.class$("javax.swing.event.MenuListener")) : class$javax$swing$event$MenuListener, menuListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.listenerList.remove(class$javax$swing$event$MenuListener == null ? (class$javax$swing$event$MenuListener = JMenu.class$("javax.swing.event.MenuListener")) : class$javax$swing$event$MenuListener, menuListener);
    }

    protected void fireMenuSelected() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuListener == null ? JMenu.class$("javax.swing.event.MenuListener") : class$javax$swing$event$MenuListener)) {
                if (objectArray[n + 1] == null) {
                    throw new Error(this.getText() + " has a NULL Listener!! " + n);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n + 1]).menuSelected(this.menuEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuDeselected() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuListener == null ? JMenu.class$("javax.swing.event.MenuListener") : class$javax$swing$event$MenuListener)) {
                if (objectArray[n + 1] == null) {
                    throw new Error(this.getText() + " has a NULL Listener!! " + n);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n + 1]).menuDeselected(this.menuEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuListener == null ? JMenu.class$("javax.swing.event.MenuListener") : class$javax$swing$event$MenuListener)) {
                if (objectArray[n + 1] == null) {
                    throw new Error(this.getText() + " has a NULL Listener!! " + n);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n + 1]).menuCanceled(this.menuEvent);
            }
            n -= 2;
        }
    }

    private ChangeListener createMenuChangeListener() {
        return new MenuChangeListener();
    }

    protected WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new WinListener(jPopupMenu);
    }

    public void menuSelectionChanged(boolean bl) {
        this.setSelected(bl);
    }

    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        MenuElement[] menuElementArray = new MenuElement[]{this.popupMenu};
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1005: {
                this.receivedKeyPressed = false;
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        switch (keyEvent.getID()) {
            case 401: {
                if (this.isSelected()) {
                    this.receivedKeyPressed = true;
                    bl = true;
                    break;
                }
                this.receivedKeyPressed = false;
                break;
            }
            case 402: {
                if (!this.receivedKeyPressed) break;
                this.receivedKeyPressed = false;
                bl = true;
                break;
            }
            default: {
                bl = this.receivedKeyPressed;
            }
        }
        if (bl) {
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.isSelected() && (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t')) {
            if ((Boolean)UIManager.get("Menu.consumesTabs") == Boolean.TRUE) {
                keyEvent.consume();
                return;
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        super.processKeyEvent(keyEvent);
    }

    public void doClick(int n) {
        MenuElement[] menuElementArray = this.buildMenuElementArray(this);
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
    }

    private MenuElement[] buildMenuElementArray(JMenu jMenu) {
        Vector vector = new Vector();
        Component component = jMenu.getPopupMenu();
        while (true) {
            if (component instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = component;
                vector.insertElementAt(jPopupMenu, 0);
                component = jPopupMenu.getInvoker();
                continue;
            }
            if (component instanceof JMenu) {
                JMenu jMenu2 = (JMenu)component;
                vector.insertElementAt(jMenu2, 0);
                component = jMenu2.getParent();
                continue;
            }
            if (component instanceof JMenuBar) break;
        }
        JMenuBar jMenuBar = (JMenuBar)component;
        vector.insertElementAt(jMenuBar, 0);
        Object[] objectArray = new MenuElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        protected AccessibleJMenu() {
            super(JMenu.this);
        }

        public int getAccessibleChildrenCount() {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n = 0;
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof Accessible) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        public Accessible getAccessibleChild(int n) {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n2 = 0;
            int n3 = 0;
            while (n3 < componentArray.length) {
                if (componentArray[n3] instanceof Accessible) {
                    if (n2 == n) {
                        if (componentArray[n3] instanceof JComponent) {
                            AccessibleContext accessibleContext = ((Accessible)((Object)componentArray[n3])).getAccessibleContext();
                            accessibleContext.setAccessibleParent(JMenu.this);
                        }
                        return (Accessible)((Object)componentArray[n3]);
                    }
                    ++n2;
                }
                ++n3;
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n = 0;
                while (n < menuElementArray.length) {
                    if (menuElementArray[n] == JMenu.this && n + 1 < menuElementArray.length) {
                        return 1;
                    }
                    ++n;
                }
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return null;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n2 = 0;
                while (n2 < menuElementArray.length) {
                    if (menuElementArray[n2] == JMenu.this) {
                        while (++n2 < menuElementArray.length) {
                            if (!(menuElementArray[n2] instanceof JMenuItem)) continue;
                            return (Accessible)((Object)menuElementArray[n2]);
                        }
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                JMenuItem jMenuItem = JMenu.this.getItem(n);
                int n2 = 0;
                while (n2 < menuElementArray.length) {
                    if (menuElementArray[n2] == jMenuItem) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public void addAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = JMenu.this.getItem(n);
            if (jMenuItem != null) {
                if (jMenuItem instanceof JMenu) {
                    MenuElement[] menuElementArray = JMenu.this.buildMenuElementArray((JMenu)jMenuItem);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                } else {
                    jMenuItem.doClick();
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
            }
        }

        public void removeAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = JMenu.this.getItem(n);
            if (jMenuItem != null && jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isSelected()) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                int n2 = 0;
                while (n2 < menuElementArray.length - 2) {
                    menuElementArray2[n2] = menuElementArray[n2];
                    ++n2;
                }
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            }
        }

        public void clearAccessibleSelection() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n = 0;
                while (n < menuElementArray.length) {
                    if (menuElementArray[n] == JMenu.this) {
                        MenuElement[] menuElementArray2 = new MenuElement[n + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n);
                        menuElementArray2[n] = JMenu.this.getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    }
                    ++n;
                }
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        JPopupMenu popupMenu;

        public WinListener(JPopupMenu jPopupMenu) {
            this.popupMenu = jPopupMenu;
        }

        public void windowClosing(WindowEvent windowEvent) {
            JMenu.this.setSelected(false);
        }
    }

    class MenuChangeListener
    implements ChangeListener,
    Serializable {
        boolean isSelected = false;

        MenuChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ButtonModel buttonModel = (ButtonModel)changeEvent.getSource();
            boolean bl = buttonModel.isSelected();
            if (bl != this.isSelected) {
                if (bl) {
                    JMenu.this.fireMenuSelected();
                } else {
                    JMenu.this.fireMenuDeselected();
                }
                this.isSelected = bl;
            }
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        WeakReference menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.setTarget(jMenuItem);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JMenuItem jMenuItem = this.getTarget();
            if (jMenuItem == null) {
                Action action = (Action)propertyChangeEvent.getSource();
                action.removePropertyChangeListener(this);
            } else if (string.equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                jMenuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                jMenuItem.setEnabled(bl);
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                jMenuItem.setIcon(icon);
                jMenuItem.invalidate();
                jMenuItem.repaint();
            } else if (string.equals("ActionCommandKey")) {
                jMenuItem.setActionCommand((String)propertyChangeEvent.getNewValue());
            }
        }

        public void setTarget(JMenuItem jMenuItem) {
            this.menuItem = new WeakReference(jMenuItem);
        }

        public JMenuItem getTarget() {
            return (JMenuItem)this.menuItem.get();
        }
    }
}

