/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalTabbedPaneUI
extends BasicTabbedPaneUI {
    protected int minTabWidth = 40;
    protected Color tabAreaBackground;
    protected Color selectColor;
    protected Color selectHighlight;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalTabbedPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n4 + (n6 - 1);
        int n8 = n3 + (n5 - 1);
        switch (n) {
            case 2: {
                this.paintLeftTabBorder(n2, graphics, n3, n4, n5, n6, n7, n8, bl);
                break;
            }
            case 3: {
                this.paintBottomTabBorder(n2, graphics, n3, n4, n5, n6, n7, n8, bl);
                break;
            }
            case 4: {
                this.paintRightTabBorder(n2, graphics, n3, n4, n5, n6, n7, n8, bl);
                break;
            }
            default: {
                this.paintTopTabBorder(n2, graphics, n3, n4, n5, n6, n7, n8, bl);
            }
        }
    }

    protected void paintTopTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.getRunForTab(this.tabPane.getTabCount(), n);
        int n9 = this.lastTabInRun(this.tabPane.getTabCount(), n8);
        int n10 = this.tabRuns[n8];
        boolean bl2 = MetalUtils.isLeftToRight(this.tabPane);
        int n11 = n5 - 1;
        int n12 = n4 - 1;
        if (this.shouldFillGap(n8, n, n2, n3)) {
            graphics.translate(n2, n3);
            if (bl2) {
                graphics.setColor(this.getColorForGap(n8, n2, n3 + 1));
                graphics.fillRect(1, 0, 5, 3);
                graphics.fillRect(1, 3, 2, 2);
            } else {
                graphics.setColor(this.getColorForGap(n8, n2 + n4 - 1, n3 + 1));
                graphics.fillRect(n12 - 5, 0, 5, 3);
                graphics.fillRect(n12 - 2, 3, 2, 2);
            }
            graphics.translate(-n2, -n3);
        }
        graphics.translate(n2, n3);
        graphics.setColor(this.darkShadow);
        if (bl2) {
            graphics.drawLine(1, 5, 6, 0);
            graphics.drawLine(6, 0, n12, 0);
            if (n == n9) {
                graphics.drawLine(n12, 1, n12, n11);
            }
            if (n != this.tabRuns[this.runCount - 1]) {
                graphics.drawLine(0, 0, 0, n11);
            } else {
                graphics.drawLine(0, 6, 0, n11);
            }
        } else {
            graphics.drawLine(n12 - 1, 5, n12 - 6, 0);
            graphics.drawLine(n12 - 6, 0, 0, 0);
            if (n != this.tabRuns[this.runCount - 1]) {
                graphics.drawLine(n12, 0, n12, n11);
            } else {
                graphics.drawLine(n12, 6, n12, n11);
            }
            if (n == n9) {
                graphics.drawLine(0, 1, 0, n11);
            }
        }
        graphics.setColor(bl ? this.selectHighlight : this.highlight);
        if (bl2) {
            graphics.drawLine(1, 6, 6, 1);
            graphics.drawLine(6, 1, n12, 1);
            graphics.drawLine(1, 6, 1, n11);
            if (n == n10 && n != this.tabRuns[this.runCount - 1]) {
                if (this.tabPane.getSelectedIndex() == this.tabRuns[n8 + 1]) {
                    graphics.setColor(this.selectHighlight);
                } else {
                    graphics.setColor(this.highlight);
                }
                graphics.drawLine(1, 0, 1, 4);
            }
        } else {
            graphics.drawLine(n12 - 1, 6, n12 - 6, 1);
            graphics.drawLine(n12 - 6, 1, 1, 1);
            if (n == n9) {
                graphics.drawLine(1, 1, 1, n11);
            } else {
                graphics.drawLine(0, 1, 0, n11);
            }
        }
        graphics.translate(-n2, -n3);
    }

    protected boolean shouldFillGap(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n == this.runCount - 2) {
            int n5;
            int n6;
            int n7;
            Rectangle rectangle = this.getTabBounds(this.tabPane, this.tabPane.getTabCount() - 1);
            Rectangle rectangle2 = this.getTabBounds(this.tabPane, n2);
            if (MetalUtils.isLeftToRight(this.tabPane) ? (n7 = rectangle.x + rectangle.width - 1) > rectangle2.x + 2 : (n6 = rectangle.x) < (n5 = rectangle2.x + rectangle2.width - 1) - 2) {
                return true;
            }
        } else {
            bl = n != this.runCount - 1;
        }
        return bl;
    }

    protected Color getColorForGap(int n, int n2, int n3) {
        int n4 = this.tabPane.getSelectedIndex();
        int n5 = this.tabRuns[n + 1];
        int n6 = this.lastTabInRun(this.tabPane.getTabCount(), n + 1);
        int n7 = -1;
        int n8 = n5;
        while (n8 <= n6) {
            Rectangle rectangle = this.getTabBounds(this.tabPane, n8);
            int n9 = rectangle.x;
            int n10 = rectangle.x + rectangle.width - 1;
            if (MetalUtils.isLeftToRight(this.tabPane) ? n9 <= n2 && n10 - 4 > n2 : n9 + 4 < n2 && n10 >= n2) {
                return n4 == n8 ? this.selectColor : this.tabPane.getBackgroundAt(n8);
            }
            ++n8;
        }
        return this.tabPane.getBackground();
    }

    protected void paintLeftTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.tabPane.getTabCount();
        int n9 = this.getRunForTab(n8, n);
        int n10 = this.lastTabInRun(n8, n9);
        int n11 = this.tabRuns[n9];
        graphics.translate(n2, n3);
        int n12 = n5 - 1;
        int n13 = n4 - 1;
        if (n != n11) {
            graphics.setColor(this.tabPane.getSelectedIndex() == n - 1 ? this.selectColor : this.tabPane.getBackgroundAt(n - 1));
            graphics.fillRect(2, 0, 4, 3);
            graphics.drawLine(2, 3, 2, 3);
        }
        graphics.setColor(bl ? this.selectHighlight : this.highlight);
        graphics.drawLine(1, 6, 6, 1);
        graphics.drawLine(6, 1, n13, 1);
        graphics.drawLine(1, 6, 1, n12);
        if (n != n11) {
            graphics.setColor(this.tabPane.getSelectedIndex() == n - 1 ? this.selectHighlight : this.highlight);
            graphics.drawLine(1, 0, 1, 4);
        }
        graphics.setColor(this.darkShadow);
        graphics.drawLine(1, 5, 6, 0);
        graphics.drawLine(6, 0, n13, 0);
        if (n != n11) {
            graphics.drawLine(0, 0, 0, n12);
        } else {
            graphics.drawLine(0, 6, 0, n12);
        }
        if (n == n10) {
            graphics.drawLine(0, n12, n13, n12);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintBottomTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.tabPane.getTabCount();
        int n9 = this.getRunForTab(n8, n);
        int n10 = this.lastTabInRun(n8, n9);
        int n11 = this.tabRuns[n9];
        boolean bl2 = MetalUtils.isLeftToRight(this.tabPane);
        int n12 = n5 - 1;
        int n13 = n4 - 1;
        if (this.shouldFillGap(n9, n, n2, n3)) {
            graphics.translate(n2, n3);
            if (bl2) {
                graphics.setColor(this.getColorForGap(n9, n2, n3));
                graphics.fillRect(1, n12 - 4, 3, 5);
                graphics.fillRect(4, n12 - 1, 2, 2);
            } else {
                graphics.setColor(this.getColorForGap(n9, n2 + n4 - 1, n3));
                graphics.fillRect(n13 - 3, n12 - 3, 3, 4);
                graphics.fillRect(n13 - 5, n12 - 1, 2, 2);
                graphics.drawLine(n13 - 1, n12 - 4, n13 - 1, n12 - 4);
            }
            graphics.translate(-n2, -n3);
        }
        graphics.translate(n2, n3);
        graphics.setColor(this.darkShadow);
        if (bl2) {
            graphics.drawLine(1, n12 - 5, 6, n12);
            graphics.drawLine(6, n12, n13, n12);
            if (n == n10) {
                graphics.drawLine(n13, 0, n13, n12);
            }
            if (n != this.tabRuns[this.runCount - 1]) {
                graphics.drawLine(0, 0, 0, n12);
            } else {
                graphics.drawLine(0, 0, 0, n12 - 6);
            }
        } else {
            graphics.drawLine(n13 - 1, n12 - 5, n13 - 6, n12);
            graphics.drawLine(n13 - 6, n12, 0, n12);
            if (n != this.tabRuns[this.runCount - 1]) {
                graphics.drawLine(n13, 0, n13, n12);
            } else {
                graphics.drawLine(n13, 0, n13, n12 - 6);
            }
            if (n == n10) {
                graphics.drawLine(0, 0, 0, n12);
            }
        }
        graphics.setColor(bl ? this.selectHighlight : this.highlight);
        if (bl2) {
            graphics.drawLine(1, n12 - 6, 6, n12 - 1);
            graphics.drawLine(1, 0, 1, n12 - 6);
            if (n == n11 && n != this.tabRuns[this.runCount - 1]) {
                if (this.tabPane.getSelectedIndex() == this.tabRuns[n9 + 1]) {
                    graphics.setColor(this.selectHighlight);
                } else {
                    graphics.setColor(this.highlight);
                }
                graphics.drawLine(1, n12 - 4, 1, n12);
            }
        } else if (n == n10) {
            graphics.drawLine(1, 0, 1, n12 - 1);
        } else {
            graphics.drawLine(0, 0, 0, n12 - 1);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintRightTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.tabPane.getTabCount();
        int n9 = this.getRunForTab(n8, n);
        int n10 = this.lastTabInRun(n8, n9);
        int n11 = this.tabRuns[n9];
        graphics.translate(n2, n3);
        int n12 = n5 - 1;
        int n13 = n4 - 1;
        if (n != n11) {
            graphics.setColor(this.tabPane.getSelectedIndex() == n - 1 ? this.tabAreaBackground : this.tabPane.getBackgroundAt(n - 1));
            graphics.fillRect(n13 - 5, 0, 5, 3);
            graphics.fillRect(n13 - 2, 3, 2, 2);
        }
        graphics.setColor(bl ? this.selectHighlight : this.highlight);
        graphics.drawLine(n13 - 6, 1, n13 - 1, 6);
        graphics.drawLine(0, 1, n13 - 6, 1);
        if (!bl) {
            graphics.drawLine(0, 1, 0, n12);
        }
        graphics.setColor(this.darkShadow);
        graphics.drawLine(n13 - 6, 0, n13, 6);
        graphics.drawLine(0, 0, n13 - 6, 0);
        if (n != n11) {
            graphics.drawLine(n13, 0, n13, n12);
        } else {
            graphics.drawLine(n13, 6, n13, n12);
        }
        if (n == n10) {
            graphics.drawLine(0, n12, n13, n12);
        }
        graphics.translate(-n2, -n3);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(this.tabAreaBackground);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n6 / 2;
        if (bl) {
            graphics.setColor(this.selectColor);
        } else {
            graphics.setColor(this.tabPane.getBackgroundAt(n2));
        }
        if (MetalUtils.isLeftToRight(this.tabPane)) {
            switch (n) {
                case 2: {
                    graphics.fillRect(n3 + 5, n4 + 1, n5 - 5, n6 - 1);
                    graphics.fillRect(n3 + 2, n4 + 4, 3, n6 - 4);
                    break;
                }
                case 3: {
                    graphics.fillRect(n3 + 2, n4, n5 - 2, n6 - 4);
                    graphics.fillRect(n3 + 5, n4 + (n6 - 1) - 3, n5 - 5, 3);
                    break;
                }
                case 4: {
                    graphics.fillRect(n3 + 1, n4 + 1, n5 - 5, n6 - 1);
                    graphics.fillRect(n3 + (n5 - 1) - 3, n4 + 5, 3, n6 - 5);
                    break;
                }
                default: {
                    graphics.fillRect(n3 + 4, n4 + 2, n5 - 1 - 3, n6 - 1 - 1);
                    graphics.fillRect(n3 + 2, n4 + 5, 2, n6 - 5);
                    break;
                }
            }
        } else {
            switch (n) {
                case 2: {
                    graphics.fillRect(n3 + 5, n4 + 1, n5 - 5, n6 - 1);
                    graphics.fillRect(n3 + 2, n4 + 4, 3, n6 - 4);
                    break;
                }
                case 3: {
                    graphics.fillRect(n3, n4, n5 - 5, n6 - 1);
                    graphics.fillRect(n3 + (n5 - 1) - 4, n4, 4, n6 - 5);
                    graphics.fillRect(n3 + (n5 - 1) - 4, n4 + (n6 - 1) - 4, 2, 2);
                    break;
                }
                case 4: {
                    graphics.fillRect(n3 + 1, n4 + 1, n5 - 5, n6 - 1);
                    graphics.fillRect(n3 + (n5 - 1) - 3, n4 + 5, 3, n6 - 5);
                    break;
                }
                default: {
                    graphics.fillRect(n3, n4 + 2, n5 - 1 - 3, n6 - 1 - 1);
                    graphics.fillRect(n3 + (n5 - 1) - 3, n4 + 4, 3, n6 - 4);
                }
            }
        }
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return 0;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getTabPlacement();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (this.tabPane.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            switch (n) {
                case 2: {
                    graphics.fillRect(insets.left, insets.top, this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth), dimension.height - insets.bottom - insets.top);
                    break;
                }
                case 3: {
                    int n2 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                    graphics.fillRect(insets.left, dimension.height - insets.bottom - n2, dimension.width - insets.left - insets.right, n2);
                    break;
                }
                case 4: {
                    int n3 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                    graphics.fillRect(dimension.width - insets.right - n3, insets.top, n3, dimension.height - insets.top - insets.bottom);
                    break;
                }
                default: {
                    graphics.fillRect(insets.left, insets.top, dimension.width - insets.right - insets.left, this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight));
                    this.paintHighlightBelowTab();
                }
            }
        }
        super.paint(graphics, jComponent);
    }

    protected void paintHighlightBelowTab() {
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.tabPane.hasFocus() && bl) {
            Rectangle rectangle3 = rectangleArray[n2];
            boolean bl2 = this.isLastInRun(n2);
            graphics.setColor(this.focus);
            graphics.translate(rectangle3.x, rectangle3.y);
            int n3 = rectangle3.width - 1;
            int n4 = rectangle3.height - 1;
            boolean bl3 = MetalUtils.isLeftToRight(this.tabPane);
            switch (n) {
                case 4: {
                    graphics.drawLine(n3 - 6, 2, n3 - 2, 6);
                    graphics.drawLine(1, 2, n3 - 6, 2);
                    graphics.drawLine(n3 - 2, 6, n3 - 2, n4);
                    graphics.drawLine(1, 2, 1, n4);
                    graphics.drawLine(1, n4, n3 - 2, n4);
                    break;
                }
                case 3: {
                    if (bl3) {
                        graphics.drawLine(2, n4 - 6, 6, n4 - 2);
                        graphics.drawLine(6, n4 - 2, n3, n4 - 2);
                        graphics.drawLine(2, 0, 2, n4 - 6);
                        graphics.drawLine(2, 0, n3, 0);
                        graphics.drawLine(n3, 0, n3, n4 - 2);
                        break;
                    }
                    graphics.drawLine(n3 - 2, n4 - 6, n3 - 6, n4 - 2);
                    graphics.drawLine(n3 - 2, 0, n3 - 2, n4 - 6);
                    if (bl2) {
                        graphics.drawLine(2, n4 - 2, n3 - 6, n4 - 2);
                        graphics.drawLine(2, 0, n3 - 2, 0);
                        graphics.drawLine(2, 0, 2, n4 - 2);
                        break;
                    }
                    graphics.drawLine(1, n4 - 2, n3 - 6, n4 - 2);
                    graphics.drawLine(1, 0, n3 - 2, 0);
                    graphics.drawLine(1, 0, 1, n4 - 2);
                    break;
                }
                case 2: {
                    graphics.drawLine(2, 6, 6, 2);
                    graphics.drawLine(2, 6, 2, n4 - 1);
                    graphics.drawLine(6, 2, n3, 2);
                    graphics.drawLine(n3, 2, n3, n4 - 1);
                    graphics.drawLine(2, n4 - 1, n3, n4 - 1);
                    break;
                }
                default: {
                    if (bl3) {
                        graphics.drawLine(2, 6, 6, 2);
                        graphics.drawLine(2, 6, 2, n4 - 1);
                        graphics.drawLine(6, 2, n3, 2);
                        graphics.drawLine(n3, 2, n3, n4 - 1);
                        graphics.drawLine(2, n4 - 1, n3, n4 - 1);
                        break;
                    }
                    graphics.drawLine(n3 - 2, 6, n3 - 6, 2);
                    graphics.drawLine(n3 - 2, 6, n3 - 2, n4 - 1);
                    if (bl2) {
                        graphics.drawLine(n3 - 6, 2, 2, 2);
                        graphics.drawLine(2, 2, 2, n4 - 1);
                        graphics.drawLine(n3 - 2, n4 - 1, 2, n4 - 1);
                        break;
                    }
                    graphics.drawLine(n3 - 6, 2, 1, 2);
                    graphics.drawLine(1, 2, 1, n4 - 1);
                    graphics.drawLine(n3 - 2, n4 - 1, 1, n4 - 1);
                }
            }
            graphics.translate(-rectangle3.x, -rectangle3.y);
        }
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = MetalUtils.isLeftToRight(this.tabPane);
        int n7 = n3 + n5 - 1;
        graphics.setColor(this.selectHighlight);
        if (n != 1 || n2 < 0 || this.rects[n2].y + this.rects[n2].height + 1 < n4) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
        } else {
            Rectangle rectangle = this.rects[n2];
            boolean bl2 = this.isLastInRun(n2);
            if (bl || bl2) {
                graphics.drawLine(n3, n4, rectangle.x + 1, n4);
            } else {
                graphics.drawLine(n3, n4, rectangle.x, n4);
            }
            if (rectangle.x + rectangle.width < n7 - 1) {
                if (bl && !bl2) {
                    graphics.drawLine(rectangle.x + rectangle.width, n4, n7 - 1, n4);
                } else {
                    graphics.drawLine(rectangle.x + rectangle.width - 1, n4, n7 - 1, n4);
                }
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = MetalUtils.isLeftToRight(this.tabPane);
        int n7 = n4 + n6 - 1;
        int n8 = n3 + n5 - 1;
        graphics.setColor(this.shadow);
        if (n != 3 || n2 < 0 || this.rects[n2].y - 1 > n6) {
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            Rectangle rectangle = this.rects[n2];
            boolean bl2 = this.isLastInRun(n2);
            graphics.setColor(this.darkShadow);
            if (bl || bl2) {
                graphics.drawLine(n3, n7, rectangle.x, n7);
            } else {
                graphics.drawLine(n3, n7, rectangle.x - 1, n7);
            }
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                if (bl && !bl2) {
                    graphics.drawLine(rectangle.x + rectangle.width, n7, n8, n7);
                } else {
                    graphics.drawLine(rectangle.x + rectangle.width - 1, n7, n8, n7);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.selectHighlight);
        if (n != 2 || n2 < 0 || this.rects[n2].x + this.rects[n2].width + 1 < n3) {
            graphics.drawLine(n3, n4, n3, n4 + n6 - 2);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.drawLine(n3, n4, n3, rectangle.y + 1);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.drawLine(n3, rectangle.y + rectangle.height + 1, n3, n4 + n6 + 2);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.shadow);
        if (n != 4 || n2 < 0 || this.rects[n2].x - 1 > n5) {
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            Rectangle rectangle = this.rects[n2];
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, rectangle.y);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 1, rectangle.y + rectangle.height, n3 + n5 - 1, n4 + n6 - 2);
            }
        }
    }

    protected int calculateMaxTabHeight(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.tabPane.getTabCount()) {
            Icon icon = this.tabPane.getIconAt(n3);
            if (icon != null && icon.getIconHeight() > n2) {
                bl = true;
                break;
            }
            ++n3;
        }
        return super.calculateMaxTabHeight(n) - (bl ? this.tabInsets.top + this.tabInsets.bottom : 0);
    }

    protected int getTabRunOverlay(int n) {
        if (n == 2 || n == 4) {
            int n2 = this.calculateMaxTabHeight(n);
            return n2 / 2;
        }
        return 0;
    }

    protected boolean shouldRotateTabRuns(int n, int n2) {
        return false;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return this.runCount > 1 && n2 < this.runCount - 1;
    }

    private boolean isLastInRun(int n) {
        int n2 = this.getRunForTab(this.tabPane.getTabCount(), n);
        int n3 = this.lastTabInRun(this.tabPane.getTabCount(), n2);
        return n == n3;
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            if (n == 1 || n == 3) {
                super.normalizeTabRuns(n, n2, n3, n4);
            }
        }

        protected void rotateTabRuns(int n, int n2) {
        }

        protected void padSelectedTab(int n, int n2) {
        }
    }
}

