/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class PhotoAlbum
extends AbstractTool {
    public PhotoAlbum() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument((AbstractTool)this, "srcdir", "The directory containing the image files", false));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("PhotoAlbum", true, true, true);
        this.internalFrame.setSize(550, 250);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().add(this.getConsole(40, 30));
    }

    public void execute() {
        try {
            if (this.getValue("srcdir") == null) {
                throw new InstantiationException("You need to choose a source directory");
            }
            File file = (File)this.getValue("srcdir");
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            Document document = new Document();
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file2));
            pdfWriter.setViewerPreferences(64);
            PdfPageLabels pdfPageLabels = new PdfPageLabels();
            TreeSet<File> treeSet = new TreeSet<File>();
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                treeSet.add(fileArray[i]);
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                File file3 = (File)iterator.next();
                System.out.println("Testing image: " + file3.getName());
                try {
                    int n;
                    Image image = Image.getInstance(file3.getAbsolutePath());
                    int n2 = image.getDpiX();
                    if (n2 == 0) {
                        n2 = 72;
                    }
                    if ((n = image.getDpiY()) == 0) {
                        n = 72;
                    }
                    float f = 72.0f * image.plainWidth() / (float)n2;
                    float f2 = 72.0f * image.plainHeight() / (float)n;
                    image.scaleAbsolute(f, f2);
                    document.setPageSize(new Rectangle(f, f2));
                    if (document.isOpen()) {
                        document.newPage();
                    } else {
                        document.open();
                    }
                    image.setAbsolutePosition(0.0f, 0.0f);
                    document.add(image);
                    pdfPageLabels.addPageLabel(pdfWriter.getPageNumber(), PdfPageLabels.EMPTY, file3.getName());
                    System.out.println("Added image: " + file3.getName());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            if (document.isOpen()) {
                pdfWriter.setPageLabels(pdfPageLabels);
                document.close();
            } else {
                System.err.println("No images were found in directory " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        PhotoAlbum photoAlbum = new PhotoAlbum();
        if (stringArray.length < 2) {
            System.err.println(photoAlbum.getUsage());
        }
        photoAlbum.setArguments(stringArray);
        photoAlbum.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        PhotoAlbum.addVersion("$Id: PhotoAlbum.java,v 1.3 2005/08/29 09:21:56 blowagie Exp $");
    }
}

